/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import exnihilocreatio.json.JsonHelper;
import exnihilocreatio.util.LogUtil;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lexnihilocreatio/json/CustomFluidJson;", "Lcom/google/gson/JsonDeserializer;", "Lnet/minecraftforge/fluids/Fluid;", "Lcom/google/gson/JsonSerializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "exnihilocreatio"})
public final class CustomFluidJson
implements JsonDeserializer<Fluid>,
JsonSerializer<Fluid> {
    public static final CustomFluidJson INSTANCE;

    @NotNull
    public JsonElement serialize(@NotNull Fluid src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        LogUtil.debug("Serialized fluid " + src + " as " + src.getName());
        return (JsonElement)new JsonPrimitive(src.getName());
    }

    @NotNull
    public Fluid deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        JsonHelper helper;
        String name;
        Fluid fluid;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (json.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive, (String)"json.asJsonPrimitive");
            if (jsonPrimitive.isString()) {
                Fluid fluid2 = FluidRegistry.getFluid((String)json.getAsString());
                Intrinsics.checkExpressionValueIsNotNull((Object)fluid2, (String)"FluidRegistry.getFluid(json.asString)");
                return fluid2;
            }
        }
        if ((fluid = FluidRegistry.getFluid((String)(name = (helper = new JsonHelper(json)).getString("name")))) == null) {
            LogUtil.error("Error parsing JSON: Invalid Fluid: " + json);
            LogUtil.error("This may result in crashing or other undefined behavior");
            Fluid fluid3 = FluidRegistry.WATER;
            Intrinsics.checkExpressionValueIsNotNull((Object)fluid3, (String)"FluidRegistry.WATER");
            return fluid3;
        }
        return fluid;
    }

    private CustomFluidJson() {
    }

    static {
        CustomFluidJson customFluidJson;
        INSTANCE = customFluidJson = new CustomFluidJson();
    }
}

