/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import exnihilocreatio.json.JsonHelper;
import exnihilocreatio.registries.types.HammerReward;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.LogUtil;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lexnihilocreatio/json/CustomHammerRewardJson;", "Lcom/google/gson/JsonDeserializer;", "Lexnihilocreatio/registries/types/HammerReward;", "Lcom/google/gson/JsonSerializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "exnihilocreatio"})
public final class CustomHammerRewardJson
implements JsonDeserializer<HammerReward>,
JsonSerializer<HammerReward> {
    public static final CustomHammerRewardJson INSTANCE;

    @NotNull
    public JsonElement serialize(@NotNull HammerReward src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonObject obj = new JsonObject();
        StringBuilder stringBuilder = new StringBuilder();
        Item item = src.getStack().func_77973_b();
        Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"src.stack.item");
        ResourceLocation resourceLocation = item.getRegistryName();
        if (resourceLocation == null) {
            Intrinsics.throwNpe();
        }
        obj.addProperty("item", stringBuilder.append(resourceLocation.toString()).append(":").append(src.getStack().func_77960_j()).toString());
        obj.addProperty("amount", (Number)src.getStack().func_190916_E());
        obj.addProperty("miningLevel", (Number)src.getMiningLevel());
        obj.addProperty("chance", (Number)Float.valueOf(src.getChance()));
        obj.addProperty("fortuneChance", (Number)Float.valueOf(src.getFortuneChance()));
        return (JsonElement)obj;
    }

    @NotNull
    public HammerReward deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        ItemStack itemStack;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonHelper helper = new JsonHelper(json);
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("item")) {
            ItemInfo info = new ItemInfo(helper.getString("item"));
            if (!info.isValid()) {
                LogUtil.error("Error parsing JSON: Invalid Item: " + json);
                ItemStack itemStack2 = ItemStack.field_190927_a;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"ItemStack.EMPTY");
                return new HammerReward(itemStack2, 0, 0.0f, 0.0f);
            }
            itemStack = new ItemStack(info.getItem(), helper.getInteger("amount"), info.getMeta());
        } else {
            Object object = context.deserialize(json.getAsJsonObject().get("stack"), (Type)((Object)ItemStack.class));
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"context.deserialize(json\u2026), ItemStack::class.java)");
            itemStack = (ItemStack)object;
        }
        ItemStack stack = itemStack;
        int miningLevel = helper.getInteger("miningLevel");
        float chance = (float)helper.getDouble("chance");
        float fortuneChance = (float)helper.getDouble("fortuneChance");
        return new HammerReward(stack, miningLevel, chance, fortuneChance);
    }

    private CustomHammerRewardJson() {
    }

    static {
        CustomHammerRewardJson customHammerRewardJson;
        INSTANCE = customHammerRewardJson = new CustomHammerRewardJson();
    }
}

