/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.networking;

import exnihilocreatio.barrel.modes.compost.BarrelModeCompost;
import exnihilocreatio.client.color.ColorGetter;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.tiles.TileBarrel;
import exnihilocreatio.util.Util;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageCompostUpdate
implements IMessage {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private float fillAmount;
    private float compValue;
    private int x;
    private int y;
    private int z;
    private ItemStack stack;
    private Color color;
    private float progress;
    private boolean isFirst;

    public MessageCompostUpdate() {
    }

    public MessageCompostUpdate(float fillAmount, Color color, ItemStack stack, float progress, float compValue, BlockPos pos, boolean isFirst) {
        this.compValue = compValue;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.color = color;
        this.fillAmount = fillAmount;
        this.stack = stack;
        this.progress = progress;
        this.isFirst = isFirst;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeFloat(this.fillAmount);
        buf.writeFloat(this.progress);
        buf.writeFloat(this.color.r);
        buf.writeFloat(this.color.g);
        buf.writeFloat(this.color.b);
        buf.writeFloat(this.color.a);
        buf.writeFloat(this.compValue);
        buf.writeBoolean(this.isFirst);
        String itemName = this.stack.func_77973_b().getRegistryName().toString();
        buf.writeInt(itemName.length());
        buf.writeCharSequence((CharSequence)this.stack.func_77973_b().getRegistryName().toString(), CHARSET);
        buf.writeInt(this.stack.func_77960_j());
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.fillAmount = buf.readFloat();
        this.progress = buf.readFloat();
        this.color = new Color(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
        this.compValue = buf.readFloat();
        this.isFirst = buf.readBoolean();
        int length = buf.readInt();
        String name = buf.readCharSequence(length, Charset.defaultCharset()).toString();
        int meta = buf.readInt();
        Item item = Item.func_111206_d((String)name);
        this.stack = item != null ? new ItemStack(item, 1, meta) : ItemStack.field_190927_a;
    }

    public String toString() {
        return "MessageCompostUpdate{fillAmount=" + this.fillAmount + ", compValue=" + this.compValue + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", stack=" + this.stack + ", color=" + this.color + ", progress=" + this.progress + '}';
    }

    public static class MessageCompostAmountUpdateHandler
    implements IMessageHandler<MessageCompostUpdate, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(final MessageCompostUpdate msg, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void run() {
                    TileEntity entity = Minecraft.func_71410_x().field_71439_g.func_130014_f_().func_175625_s(new BlockPos(msg.x, msg.y, msg.z));
                    if (entity instanceof TileBarrel) {
                        TileBarrel te = (TileBarrel)entity;
                        if (te.getMode() == null || !(te.getMode() instanceof BarrelModeCompost)) {
                            te.setMode("compost");
                        }
                        BarrelModeCompost mode = (BarrelModeCompost)te.getMode();
                        mode.setFillAmount(msg.fillAmount);
                        if (msg.stack.func_190926_b() && msg.compValue == 0.0f && mode.getOriginalColor() != null) {
                            mode.setColor(Color.average(mode.getOriginalColor(), Util.whiteColor, msg.progress));
                        } else {
                            Color compColor = msg.color;
                            if (compColor.equals(Color.INVALID_COLOR) && !msg.stack.func_190926_b()) {
                                compColor = ColorGetter.getColor(msg.stack);
                            }
                            if (msg.fillAmount == 0.0f || msg.isFirst) {
                                mode.setColor(compColor);
                                mode.setOriginalColor(compColor);
                            } else {
                                Color col = Color.average(mode.getColorForRender(te), compColor, msg.compValue);
                                mode.setColor(col);
                                mode.setOriginalColor(col);
                            }
                        }
                        mode.setProgress(msg.progress);
                    }
                }
            });
            return null;
        }
    }
}

