/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.recipes.defaults;

import exnihilocreatio.ModBlocks;
import exnihilocreatio.blocks.BlockSieve;
import exnihilocreatio.modules.forestry.ForestryHelper;
import exnihilocreatio.recipes.defaults.IRecipeDefaults;
import exnihilocreatio.registries.registries.CompostRegistry;
import exnihilocreatio.registries.registries.CrookRegistry;
import exnihilocreatio.registries.registries.CrucibleRegistry;
import exnihilocreatio.registries.registries.FluidBlockTransformerRegistry;
import exnihilocreatio.registries.registries.SieveRegistry;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.StackInfo;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.fluids.FluidRegistry;

public class Forestry
implements IRecipeDefaults {
    private final String MODID = "forestry";

    @Override
    public void registerCompost(CompostRegistry registry) {
        BlockInfo dirtState = new BlockInfo(Blocks.field_150346_d);
        registry.register(new ItemInfo("forestry:bee_drone_ge"), 0.0625f, dirtState, new Color("C45631"));
        registry.register(new ItemInfo("forestry:bee_princess_ge"), 0.25f, dirtState, new Color("C45631"));
        registry.register(new ItemInfo("forestry:bee_larvae_ge"), 0.0625f, dirtState, new Color("C45631"));
        registry.register(new ItemInfo("forestry:cocoon_ge"), 0.0625f, dirtState, new Color("C45631"));
        registry.register(new ItemInfo("forestry:caterpillar_ge"), 0.0625f, dirtState, new Color("C45631"));
        registry.register(new ItemInfo("forestry:peat"), 0.5f, dirtState, new Color("AF9F96"));
        registry.register(new ItemInfo("forestry:fertilizer_bio"), 0.5f, dirtState, new Color("135303"));
        registry.register(new ItemInfo("forestry:mouldy_wheat"), 0.0625f, dirtState, new Color("D3D152"));
        registry.register(new ItemInfo("forestry:decaying_wheat"), 0.125f, dirtState, new Color("D3D152"));
        registry.register(new ItemInfo("forestry:mulch"), 0.25f, dirtState, new Color("D3D152"));
        registry.register(new ItemInfo("forestry:wood_pulp"), 0.125f, dirtState, new Color("FFF1B5"));
        registry.register(new ItemInfo("forestry:pollen:0"), 0.125f, dirtState, new Color("FFFA66"));
        registry.register(new ItemInfo("forestry:pollen:1"), 0.125f, new BlockInfo(Blocks.field_150433_aE, -1), new Color("709BD3"));
        registry.register(new ItemInfo("forestry:pollen_fertile"), 0.25f, dirtState, new Color("FFFA66"));
        registry.register(new ItemInfo("forestry:propolis:0"), 0.125f, new BlockInfo(Blocks.field_180399_cE), new Color("7B934B"));
        registry.register(new ItemInfo("forestry:propolis:1"), 0.125f, new BlockInfo(Blocks.field_180399_cE), new Color("7B934B"));
        registry.register(new ItemInfo("forestry:propolis:3"), 0.125f, new BlockInfo(Blocks.field_180399_cE), new Color("7B934B"));
    }

    @Override
    public void registerCrook(CrookRegistry registry) {
        this.registerCrookBees(registry, "treeLeaves", "forestry.speciesForest", 0.02f, 0.01f, 0.001f);
        this.registerCrookBees(registry, (Block)Blocks.field_150362_t, 3, "forestry.speciesTropical", 0.02f, 0.01f, 0.001f);
        this.registerCrookBees(registry, (Block)Blocks.field_150362_t, 11, "forestry.speciesTropical", 0.02f, 0.01f, 0.001f);
        this.registerCrookBees(registry, (Block)Blocks.field_150362_t, 15, "forestry.speciesTropical", 0.02f, 0.01f, 0.001f);
        this.registerCrookBees(registry, "sand", "forestry.speciesModest", 0.05f, 0.02f, 0.01f);
        this.registerCrookBees(registry, Blocks.field_150433_aE, -1, "forestry.speciesWintry", 0.05f, 0.02f, 0.01f);
        this.registerCrookBees(registry, (Block)ModBlocks.endstoneCrushed, -1, "forestry.speciesEnded", 0.05f, 0.02f, 0.01f);
        this.registerCrookBees(registry, "dirt", "forestry.speciesMeadows", 0.05f, 0.02f, 0.01f);
    }

    private void registerCrookBees(CrookRegistry registry, String oredict, String species, float drone, float ignoble, float pristine) {
        registry.register(oredict, ForestryHelper.getDroneInfo(species).getItemStack(), drone, drone * 2.0f);
        registry.register(oredict, ForestryHelper.getIgnobleInfo(species).getItemStack(), ignoble, ignoble / 2.0f);
        registry.register(oredict, ForestryHelper.getPristineInfo(species).getItemStack(), pristine, pristine * 2.0f);
    }

    private void registerCrookBees(CrookRegistry registry, Block target, int meta, String species, float drone, float ignoble, float pristine) {
        registry.register(target, meta, ForestryHelper.getDroneInfo(species).getItemStack(), drone, drone * 2.0f);
        registry.register(target, meta, ForestryHelper.getIgnobleInfo(species).getItemStack(), ignoble, ignoble / 2.0f);
        registry.register(target, meta, ForestryHelper.getPristineInfo(species).getItemStack(), pristine, pristine * 2.0f);
    }

    @Override
    public void registerSieve(SieveRegistry registry) {
        registry.register("sand", (StackInfo)new ItemInfo("forestry:apatite"), 0.01f, BlockSieve.MeshType.STRING.getID());
        registry.register("sand", (StackInfo)new ItemInfo("forestry:apatite"), 0.02f, BlockSieve.MeshType.FLINT.getID());
        registry.register("sand", (StackInfo)new ItemInfo("forestry:apatite"), 0.03f, BlockSieve.MeshType.IRON.getID());
        registry.register("sand", (StackInfo)new ItemInfo("forestry:apatite"), 0.05f, BlockSieve.MeshType.DIAMOND.getID());
        registry.register("treeLeaves", ForestryHelper.getDroneInfo("forestry.speciesForest"), 0.05f, BlockSieve.MeshType.FLINT.getID());
        registry.register("treeLeaves", ForestryHelper.getIgnobleInfo("forestry.speciesForest"), 0.05f, BlockSieve.MeshType.IRON.getID());
        registry.register("treeLeaves", ForestryHelper.getPristineInfo("forestry.speciesForest"), 0.01f, BlockSieve.MeshType.DIAMOND.getID());
        registry.register(new ItemInfo("minecraft:leaves:3"), ForestryHelper.getDroneInfo("forestry.speciesTropical"), 0.05f, BlockSieve.MeshType.FLINT.getID());
        registry.register(new ItemInfo("minecraft:leaves:3"), ForestryHelper.getIgnobleInfo("forestry.speciesTropical"), 0.05f, BlockSieve.MeshType.IRON.getID());
        registry.register(new ItemInfo("minecraft:leaves:3"), ForestryHelper.getPristineInfo("forestry.speciesTropical"), 0.01f, BlockSieve.MeshType.DIAMOND.getID());
        registry.register(new BlockInfo("forestry:humus"), ForestryHelper.getDroneInfo("forestry.speciesMarshy"), 0.05f, BlockSieve.MeshType.FLINT.getID());
        registry.register(new BlockInfo("forestry:humus"), ForestryHelper.getIgnobleInfo("forestry.speciesMarshy"), 0.05f, BlockSieve.MeshType.IRON.getID());
        registry.register(new BlockInfo("forestry:humus"), ForestryHelper.getPristineInfo("forestry.speciesMarshy"), 0.01f, BlockSieve.MeshType.DIAMOND.getID());
    }

    @Override
    public void registerCrucibleStone(CrucibleRegistry registry) {
        registry.register("dropHoney", FluidRegistry.getFluid((String)"for.honey"), 10, new BlockInfo("forestry:bee_combs_0:0"));
        if (FluidRegistry.isFluidRegistered((String)"seed.oil")) {
            registry.register("listAllseed", FluidRegistry.getFluid((String)"seed.oil"), 10, new BlockInfo(Blocks.field_150360_v));
        } else if (FluidRegistry.isFluidRegistered((String)"seed_oil")) {
            registry.register("listAllseed", FluidRegistry.getFluid((String)"seed_oil"), 10, new BlockInfo(Blocks.field_150360_v));
        }
    }

    @Override
    public void registerFluidBlockTransform(FluidBlockTransformerRegistry registry) {
        if (FluidRegistry.isFluidRegistered((String)"seed.oil")) {
            registry.register(FluidRegistry.getFluid((String)"seed.oil"), new ItemInfo("exnihilocreatio:hive:0"), (StackInfo)new ItemInfo("exnihilocreatio:hive:1"));
        }
        if (FluidRegistry.isFluidRegistered((String)"seed_oil")) {
            registry.register(FluidRegistry.getFluid((String)"seed_oil"), new ItemInfo("exnihilocreatio:hive:0"), (StackInfo)new ItemInfo("exnihilocreatio:hive:1"));
        }
    }

    @Override
    public String getMODID() {
        return this.MODID;
    }
}

