/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.api.registries.IWitchWaterWorldRegistry;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomWitchWaterWorld;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.WitchWaterWorld;
import exnihilocreatio.util.BlockInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.jetbrains.annotations.NotNull;

public class WitchWaterWorldRegistry
extends BaseRegistryMap<Fluid, WitchWaterWorld>
implements IWitchWaterWorldRegistry {
    public WitchWaterWorldRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BlockInfo.class, (Object)CustomBlockInfoJson.INSTANCE).registerTypeAdapter(WitchWaterWorld.class, (Object)CustomWitchWaterWorld.INSTANCE).enableComplexMapKeySerialization().create(), new TypeToken<Map<String, WitchWaterWorld>>(){}.getType(), ExNihiloRegistryManager.WITCH_WATER_WORLD_DEFAULT_REGISTRY_PROVIDERS);
    }

    @Override
    public void register(Fluid key, WitchWaterWorld value) {
        ((Map)this.registry).put(key, value);
    }

    @Override
    public void register(Fluid key, Map<BlockInfo, Integer> entries) {
        this.register(key, WitchWaterWorld.fromMap(entries));
    }

    @Override
    public boolean contains(@NotNull Fluid fluid) {
        return ((Map)this.registry).containsKey(fluid);
    }

    @Override
    @NotNull
    public BlockInfo getResult(@NotNull Fluid fluid, float chance) {
        if (((Map)this.registry).containsKey(fluid)) {
            return ((WitchWaterWorld)((Map)this.registry).get(fluid)).getResult(chance);
        }
        return BlockInfo.EMPTY;
    }

    @Override
    protected void registerEntriesFromJSON(FileReader fr) {
        Map gsonInput = (Map)this.gson.fromJson((Reader)fr, new TypeToken<Map<String, WitchWaterWorld>>(){}.getType());
        for (Map.Entry entry : gsonInput.entrySet()) {
            this.register(FluidRegistry.getFluid((String)((String)entry.getKey())), (WitchWaterWorld)entry.getValue());
        }
    }

    @Override
    public void saveJson(File file) {
        HashMap mappedRegistry = new HashMap();
        for (Map.Entry entry : ((Map)this.registry).entrySet()) {
            mappedRegistry.put(((Fluid)entry.getKey()).getName(), entry.getValue());
        }
        try (FileWriter fw = new FileWriter(file);){
            if (this.typeOfSource != null) {
                this.gson.toJson(mappedRegistry, this.typeOfSource, (Appendable)fw);
            } else {
                this.gson.toJson(mappedRegistry, (Appendable)fw);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<?> getRecipeList() {
        return null;
    }

    @Override
    public void clearRegistry() {
        ((Map)this.registry).clear();
    }
}

