/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.tiles;

import exnihilocreatio.capabilities.CapabilityHeatManager;
import exnihilocreatio.capabilities.ICapabilityHeat;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.tiles.TileCrucibleBase;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class TileCrucibleStone
extends TileCrucibleBase {
    public TileCrucibleStone() {
        super(ExNihiloRegistryManager.CRUCIBLE_STONE_REGISTRY);
    }

    @Override
    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ++this.ticksSinceLast;
        if (this.ticksSinceLast >= 10) {
            this.ticksSinceLast = 0;
            int heatRate = this.getHeatRate();
            if (heatRate <= 0) {
                return;
            }
            if (this.solidAmount <= 0) {
                if (!this.itemHandler.getStackInSlot(0).func_190926_b()) {
                    this.currentItem = new ItemInfo(this.itemHandler.getStackInSlot(0));
                    this.itemHandler.getStackInSlot(0).func_190918_g(1);
                    if (this.itemHandler.getStackInSlot(0).func_190926_b()) {
                        this.itemHandler.setStackInSlot(0, ItemStack.field_190927_a);
                    }
                    this.solidAmount = this.crucibleRegistry.getMeltable(this.currentItem).getAmount();
                } else {
                    return;
                }
            }
            if (!this.itemHandler.getStackInSlot(0).func_190926_b() && this.itemHandler.getStackInSlot(0).func_77969_a(this.currentItem.getItemStack())) {
                while (heatRate > this.solidAmount && !this.itemHandler.getStackInSlot(0).func_190926_b()) {
                    this.solidAmount += this.crucibleRegistry.getMeltable(this.currentItem).getAmount();
                    this.itemHandler.getStackInSlot(0).func_190918_g(1);
                    if (!this.itemHandler.getStackInSlot(0).func_190926_b()) continue;
                    this.itemHandler.setStackInSlot(0, ItemStack.field_190927_a);
                }
            }
            if (heatRate > this.solidAmount) {
                heatRate = this.solidAmount;
            }
            if (heatRate > 0 && this.currentItem.isValid() && this.crucibleRegistry.canBeMelted(this.currentItem)) {
                FluidStack toFill = new FluidStack(FluidRegistry.getFluid((String)this.crucibleRegistry.getMeltable(this.currentItem).getFluid()), heatRate);
                int filled = this.tank.fillInternal(toFill, true);
                this.solidAmount -= filled;
            }
        }
    }

    @Override
    public int getHeatRate() {
        BlockPos posBelow = this.field_174879_c.func_177982_a(0, -1, 0);
        IBlockState stateBelow = this.func_145831_w().func_180495_p(posBelow);
        if (stateBelow == Blocks.field_150350_a.func_176223_P()) {
            return 0;
        }
        int heat = ExNihiloRegistryManager.HEAT_REGISTRY.getHeatAmount(new BlockInfo(stateBelow));
        if (heat == 0 && !Item.func_150898_a((Block)stateBelow.func_177230_c()).func_77614_k()) {
            heat = ExNihiloRegistryManager.HEAT_REGISTRY.getHeatAmount(new BlockInfo(stateBelow.func_177230_c()));
        }
        if (heat != 0) {
            if (stateBelow.func_177230_c() instanceof IFluidBlock) {
                IFluidBlock fluidBelow = (IFluidBlock)stateBelow.func_177230_c();
                float fillLevel = Math.abs(fluidBelow.getFilledPercentage(this.func_145831_w(), posBelow));
                heat = Math.round(fillLevel * (float)heat);
            } else if (stateBelow.func_177230_c() instanceof BlockLiquid) {
                float liquidHeight = BlockLiquid.func_190973_f((IBlockState)stateBelow, (IBlockAccess)this.func_145831_w(), (BlockPos)posBelow);
                heat = Math.round(liquidHeight * (float)heat);
            }
            return heat;
        }
        TileEntity tile = this.func_145831_w().func_175625_s(posBelow);
        if (tile != null && tile.hasCapability(CapabilityHeatManager.HEAT_CAPABILITY, EnumFacing.UP)) {
            return ((ICapabilityHeat)tile.getCapability(CapabilityHeatManager.HEAT_CAPABILITY, EnumFacing.UP)).getHeatRate();
        }
        return 0;
    }
}

