/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.api.prefab.module;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.util.TransformUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractModule
implements Module {
    private final Casing casing;
    private final Face face;

    protected AbstractModule(Casing casing, Face face) {
        this.casing = casing;
        this.face = face;
    }

    protected void cancelWrite() {
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            sendingPipe.cancelWrite();
        }
    }

    protected void cancelRead() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            receivingPipe.cancelRead();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean isPlayerLookingAt() {
        RayTraceResult hit = Minecraft.func_71410_x().field_71476_x;
        return hit != null && hit.field_72313_a == RayTraceResult.Type.BLOCK && this.getCasing().getPosition().equals((Object)hit.func_178782_a()) && hit.field_178784_b == Face.toEnumFacing(this.getFace());
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    protected Vec3d getPlayerLookAt() {
        RayTraceResult hit = Minecraft.func_71410_x().field_71476_x;
        if (hit != null && hit.field_72313_a == RayTraceResult.Type.BLOCK && this.getCasing().getPosition().equals((Object)hit.func_178782_a()) && hit.field_178784_b == Face.toEnumFacing(this.getFace())) {
            return new Vec3d(hit.field_72307_f.field_72450_a - (double)hit.func_178782_a().func_177958_n(), hit.field_72307_f.field_72448_b - (double)hit.func_178782_a().func_177956_o(), hit.field_72307_f.field_72449_c - (double)hit.func_178782_a().func_177952_p());
        }
        return null;
    }

    protected Vec3d hitToUV(Vec3d hitPos) {
        return TransformUtil.hitToUV(this.getFace(), hitPos);
    }

    protected boolean isVisible() {
        BlockPos neighborPos;
        World world = this.getCasing().getCasingWorld();
        if (!world.func_175667_e(neighborPos = this.getCasing().getPosition().func_177972_a(Face.toEnumFacing(this.getFace())))) {
            return false;
        }
        Chunk chunk = world.func_175726_f(neighborPos);
        if (chunk.func_76621_g()) {
            return true;
        }
        IBlockState neighborState = world.func_180495_p(neighborPos);
        Block neighborBlock = neighborState.func_177230_c();
        return !neighborBlock.doesSideBlockRendering(neighborState, (IBlockAccess)world, neighborPos, Face.toEnumFacing(this.getFace().getOpposite()));
    }

    @Override
    public Casing getCasing() {
        return this.casing;
    }

    @Override
    public Face getFace() {
        return this.face;
    }

    @Override
    public void step() {
    }

    @Override
    public void onInstalled(ItemStack stack) {
    }

    @Override
    public void onUninstalled(ItemStack stack) {
    }

    @Override
    public void onEnabled() {
    }

    @Override
    public void onDisabled() {
    }

    @Override
    public void onDisposed() {
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
    }

    @Override
    public void onWriteComplete(Port port) {
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onData(NBTTagCompound nbt) {
    }

    @Override
    public void onData(ByteBuf data) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }
}

