/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client;

import java.util.Collection;
import li.cil.tis3d.api.ManualAPI;
import li.cil.tis3d.api.prefab.manual.ItemStackTabIconRenderer;
import li.cil.tis3d.api.prefab.manual.TextureTabIconRenderer;
import li.cil.tis3d.client.gui.GuiHandlerClient;
import li.cil.tis3d.client.manual.provider.BlockImageProvider;
import li.cil.tis3d.client.manual.provider.ItemImageProvider;
import li.cil.tis3d.client.manual.provider.OreDictImageProvider;
import li.cil.tis3d.client.manual.provider.TextureImageProvider;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.client.renderer.block.ModelLoaderCasing;
import li.cil.tis3d.client.renderer.tileentity.TileEntitySpecialRendererCasing;
import li.cil.tis3d.client.renderer.tileentity.TileEntitySpecialRendererController;
import li.cil.tis3d.common.ProxyCommon;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.init.Blocks;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import li.cil.tis3d.common.tileentity.TileEntityController;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class ProxyClient
extends ProxyCommon {
    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
        super.onPreInit(event);
        MinecraftForge.EVENT_BUS.register((Object)TextureLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelLoaderCasing.INSTANCE);
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
        Collection<Item> allModules;
        super.onInit(event);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCasing.class, (TileEntitySpecialRenderer)new TileEntitySpecialRendererCasing());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityController.class, (TileEntitySpecialRenderer)new TileEntitySpecialRendererController());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)TIS3D.instance, (IGuiHandler)new GuiHandlerClient());
        ManualAPI.addProvider("", new TextureImageProvider());
        ManualAPI.addProvider("item", new ItemImageProvider());
        ManualAPI.addProvider("block", new BlockImageProvider());
        ManualAPI.addProvider("oredict", new OreDictImageProvider());
        ManualAPI.addTab(new TextureTabIconRenderer(new ResourceLocation("tis3d", "textures/gui/manual_home.png")), "tis3d.manual.home", "%LANGUAGE%/index.md");
        ManualAPI.addTab(new ItemStackTabIconRenderer(new ItemStack(Blocks.CONTROLLER)), "tis3d.manual.blocks", "%LANGUAGE%/block/index.md");
        Item module = li.cil.tis3d.common.init.Items.getModules().containsKey("module_execution") ? li.cil.tis3d.common.init.Items.getModules().get("module_execution") : ((allModules = li.cil.tis3d.common.init.Items.getModules().values()).isEmpty() ? Items.field_151137_ax : allModules.iterator().next());
        ManualAPI.addTab(new ItemStackTabIconRenderer(new ItemStack(module)), "tis3d.manual.items", "%LANGUAGE%/item/index.md");
        ManualAPI.addTab(new TextureTabIconRenderer(new ResourceLocation("tis3d", "textures/gui/manual_serial_protocols.png")), "tis3d.manual.serialProtocols", "%LANGUAGE%/serial_protocols.md");
    }

    @SubscribeEvent
    public static void handleModelRegistryEvent(ModelRegistryEvent event) {
        for (Item item : li.cil.tis3d.common.init.Items.getAllItems()) {
            ResourceLocation registryName = item.getRegistryName();
            assert (registryName != null);
            ModelResourceLocation location = ProxyClient.getModelResourceLocation(registryName);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)location);
        }
    }

    private static ModelResourceLocation getModelResourceLocation(ResourceLocation registryName) {
        if (registryName.equals((Object)ModelLoaderCasing.LOCATION_CASING)) {
            return new ModelResourceLocation(ModelLoaderCasing.LOCATION_CASING_BASE, "inventory");
        }
        return new ModelResourceLocation(registryName, "inventory");
    }
}

