/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.renderer.tileentity;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.api.util.TransformUtil;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public final class TileEntitySpecialRendererCasing
extends TileEntitySpecialRenderer<TileEntityCasing> {
    private static final Set<Class<?>> BLACKLIST = new HashSet();

    public void render(TileEntityCasing casing, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        double dx = x + 0.5;
        double dy = y + 0.5;
        double dz = z + 0.5;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)dx, (double)dy, (double)dz);
        RenderHelper.func_74518_a();
        for (Face face : Face.VALUES) {
            if (this.isRenderingBackFace(face, dx, dy, dz)) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            this.setupMatrix(face);
            this.ensureSanity();
            if (!this.isObserverHoldingKey() || !this.drawConfigOverlay(casing, face)) {
                this.drawModuleOverlay(casing, face, partialTicks);
            }
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private boolean isRenderingBackFace(Face face, double dx, double dy, double dz) {
        EnumFacing facing = Face.toEnumFacing(face.getOpposite());
        double dotProduct = (double)facing.func_82601_c() * dx + (double)facing.func_96559_d() * (dy - (double)this.field_147501_a.field_147551_g.func_70047_e()) + (double)facing.func_82599_e() * dz;
        return dotProduct < 0.0;
    }

    private void setupMatrix(Face face) {
        switch (face) {
            case Y_NEG: {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case Y_POS: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case Z_NEG: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case Z_POS: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case X_NEG: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case X_POS: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)-0.505);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
    }

    private void ensureSanity() {
        GlStateManager.func_179098_w();
        RenderUtil.bindTexture(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179112_b((int)770, (int)771);
        RenderUtil.ignoreLighting();
    }

    private boolean drawConfigOverlay(TileEntityCasing casing, Face face) {
        if (!this.isObserverKindaClose(casing)) {
            return false;
        }
        if (this.isObserverSneaking() && !casing.isLocked()) {
            Port lookingAtPort;
            TextureAtlasSprite openSprite;
            TextureAtlasSprite closedSprite;
            boolean isLookingAt = this.isObserverLookingAt(casing.func_174877_v(), face);
            if (isLookingAt) {
                closedSprite = RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_PORT_CLOSED);
                openSprite = RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_PORT_OPEN);
                RayTraceResult hit = this.field_147501_a.field_190057_j;
                BlockPos pos = hit.func_178782_a();
                assert (pos != null) : "rendererDispatcher.cameraHitResult.getBlockPos() is null even though it was non-null in isObserverLookingAt";
                Vec3d uv = TransformUtil.hitToUV(face, hit.field_72307_f.func_178788_d(new Vec3d((Vec3i)pos)));
                lookingAtPort = Port.fromUVQuadrant(uv);
            } else {
                closedSprite = RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_PORT_CLOSED_SMALL);
                openSprite = null;
                lookingAtPort = null;
            }
            GlStateManager.func_179094_E();
            for (Port port : Port.CLOCKWISE) {
                TextureAtlasSprite sprite;
                boolean isClosed = casing.isReceivingPipeLocked(face, port);
                TextureAtlasSprite textureAtlasSprite = sprite = isClosed ? closedSprite : openSprite;
                if (sprite != null) {
                    RenderUtil.drawQuad(sprite);
                }
                if (port == lookingAtPort) {
                    RenderUtil.drawQuad(RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_PORT_HIGHLIGHT));
                }
                GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            }
            GlStateManager.func_179121_F();
            return isLookingAt;
        }
        TextureAtlasSprite sprite = casing.isLocked() ? RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_LOCKED) : RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_UNLOCKED);
        RenderUtil.drawQuad(sprite);
        return true;
    }

    private void drawModuleOverlay(TileEntityCasing casing, Face face, float partialTicks) {
        TextureAtlasSprite closedSprite = RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_PORT_CLOSED_SMALL);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.005);
        for (Port port : Port.CLOCKWISE) {
            boolean isClosed = casing.isReceivingPipeLocked(face, port);
            if (isClosed) {
                RenderUtil.drawQuad(closedSprite);
            }
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        }
        GlStateManager.func_179121_F();
        Module module = casing.getModule(face);
        if (module == null) {
            return;
        }
        if (BLACKLIST.contains(module.getClass())) {
            return;
        }
        int brightness = this.func_178459_a().func_175626_b(casing.getPosition().func_177972_a(Face.toEnumFacing(face)), 0);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(brightness % 65536), (float)(brightness / 65536));
        try {
            module.render(casing.isEnabled(), partialTicks);
        }
        catch (Exception e) {
            BLACKLIST.add(module.getClass());
            TIS3D.getLog().error("A module threw an exception while rendering, won't render again!", (Throwable)e);
        }
    }

    private boolean isObserverKindaClose(TileEntityCasing casing) {
        return this.field_147501_a.field_147551_g.func_174831_c(casing.func_174877_v()) < 256.0;
    }

    private boolean isObserverHoldingKey() {
        for (ItemStack stack : this.field_147501_a.field_147551_g.func_184214_aD()) {
            if (!Items.isKey(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isObserverSneaking() {
        return this.field_147501_a.field_147551_g.func_70093_af();
    }

    private boolean isObserverLookingAt(BlockPos pos, Face face) {
        RayTraceResult hit = this.field_147501_a.field_190057_j;
        return hit != null && hit.field_72313_a == RayTraceResult.Type.BLOCK && hit.field_178784_b != null && Face.fromEnumFacing(hit.field_178784_b) == face && hit.func_178782_a() != null && Objects.equals(hit.func_178782_a(), pos);
    }
}

