/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common;

import li.cil.tis3d.api.API;
import li.cil.tis3d.api.ManualAPI;
import li.cil.tis3d.api.ModuleAPI;
import li.cil.tis3d.api.prefab.manual.ResourceContentProvider;
import li.cil.tis3d.client.manual.provider.GameRegistryPathProvider;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.api.CreativeTab;
import li.cil.tis3d.common.api.FontRendererAPIImpl;
import li.cil.tis3d.common.api.InfraredAPIImpl;
import li.cil.tis3d.common.api.ManualAPIImpl;
import li.cil.tis3d.common.api.ModuleAPIImpl;
import li.cil.tis3d.common.api.SerialAPIImpl;
import li.cil.tis3d.common.capabilities.CapabilityInfraredReceiver;
import li.cil.tis3d.common.entity.EntityInfraredPacket;
import li.cil.tis3d.common.event.TickHandlerInfraredPacket;
import li.cil.tis3d.common.event.WorldUnloadHandler;
import li.cil.tis3d.common.gui.GuiHandlerCommon;
import li.cil.tis3d.common.init.Blocks;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.integration.Integration;
import li.cil.tis3d.common.integration.redstone.RedstoneIntegration;
import li.cil.tis3d.common.item.ItemModuleReadOnlyMemory;
import li.cil.tis3d.common.module.ModuleAudio;
import li.cil.tis3d.common.module.ModuleBundledRedstone;
import li.cil.tis3d.common.module.ModuleDisplay;
import li.cil.tis3d.common.module.ModuleExecution;
import li.cil.tis3d.common.module.ModuleFacade;
import li.cil.tis3d.common.module.ModuleInfrared;
import li.cil.tis3d.common.module.ModuleKeypad;
import li.cil.tis3d.common.module.ModuleQueue;
import li.cil.tis3d.common.module.ModuleRandom;
import li.cil.tis3d.common.module.ModuleRandomAccessMemory;
import li.cil.tis3d.common.module.ModuleReadOnlyMemory;
import li.cil.tis3d.common.module.ModuleRedstone;
import li.cil.tis3d.common.module.ModuleSequencer;
import li.cil.tis3d.common.module.ModuleSerialPort;
import li.cil.tis3d.common.module.ModuleStack;
import li.cil.tis3d.common.module.ModuleTerminal;
import li.cil.tis3d.common.module.ModuleTimer;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.provider.SimpleModuleProvider;
import li.cil.tis3d.util.datafix.Fixes;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber
public class ProxyCommon {
    public void onPreInit(FMLPreInitializationEvent event) {
        Settings.load(event.getSuggestedConfigurationFile());
        API.creativeTab = new CreativeTab();
        API.fontRendererAPI = new FontRendererAPIImpl();
        API.infraredAPI = new InfraredAPIImpl();
        API.manualAPI = ManualAPIImpl.INSTANCE;
        API.moduleAPI = new ModuleAPIImpl();
        API.serialAPI = SerialAPIImpl.INSTANCE;
        CapabilityInfraredReceiver.register();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)TIS3D.instance, (IGuiHandler)new GuiHandlerCommon());
        Integration.preInit(event);
    }

    public void onInit(FMLInitializationEvent event) {
        OreDictionary.registerOre((String)"book", (Item)Items.BOOK_CODE);
        OreDictionary.registerOre((String)"book", (Item)Items.BOOK_MANUAL);
        for (String module : Constants.MODULES) {
            ProxyCommon.registerModuleOre(module);
        }
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("tis3d", "infrared_packet"), EntityInfraredPacket.class, (String)"infrared_packet", (int)1, (Object)TIS3D.instance, (int)16, (int)1, (boolean)true);
        Network.INSTANCE.init();
        Fixes.init();
        MinecraftForge.EVENT_BUS.register((Object)Network.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RedstoneIntegration.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)TickHandlerInfraredPacket.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)WorldUnloadHandler.INSTANCE);
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleAudio>("module_audio", ModuleAudio::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleBundledRedstone>("module_bundled_redstone", ModuleBundledRedstone::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleDisplay>("module_display", ModuleDisplay::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleExecution>("module_execution", ModuleExecution::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleFacade>("module_facade", ModuleFacade::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleInfrared>("module_infrared", ModuleInfrared::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleKeypad>("module_keypad", ModuleKeypad::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleQueue>("module_queue", ModuleQueue::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleRandom>("module_random", ModuleRandom::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleRandomAccessMemory>("module_random_access_memory", ModuleRandomAccessMemory::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleReadOnlyMemory>("module_read_only_memory", ModuleReadOnlyMemory::new, ItemModuleReadOnlyMemory::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleRedstone>("module_redstone", ModuleRedstone::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleSequencer>("module_sequencer", ModuleSequencer::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleSerialPort>("module_serial_port", ModuleSerialPort::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleStack>("module_stack", ModuleStack::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleTerminal>("module_terminal", ModuleTerminal::new));
        ModuleAPI.addProvider(new SimpleModuleProvider<ModuleTimer>("module_timer", ModuleTimer::new));
        ManualAPI.addProvider(new GameRegistryPathProvider());
        ManualAPI.addProvider(new ResourceContentProvider("tis3d", "doc/"));
        ManualAPI.addProvider(SerialAPIImpl.INSTANCE.getSerialProtocolContentProvider());
        Integration.init(event);
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        Integration.postInit(event);
    }

    @SubscribeEvent
    public static void handleRegisterBlocksEvent(RegistryEvent.Register<Block> event) {
        Blocks.register((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void handleRegisterItemsEvent(RegistryEvent.Register<Item> event) {
        Items.register((IForgeRegistry<Item>)event.getRegistry());
    }

    private static void registerModuleOre(String name) {
        if (Settings.disabledModules.contains(name)) {
            return;
        }
        OreDictionary.registerOre((String)"tis3d:module", (Item)((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("tis3d", name))));
    }
}

