/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.capabilities;

import javax.annotation.Nullable;
import li.cil.tis3d.api.infrared.InfraredPacket;
import li.cil.tis3d.api.infrared.InfraredReceiver;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class CapabilityInfraredReceiver {
    public static final ResourceLocation INFRARED_RECEIVER_LOCATION = new ResourceLocation("tis3d", "infrared_receiver");
    @CapabilityInject(value=InfraredReceiver.class)
    public static Capability<InfraredReceiver> INFRARED_RECEIVER_CAPABILITY;
    private static final CapabilityInfraredReceiver INSTANCE;
    private static final InfraredReceiver DEFAULT_INFRARED_RECEIVER;

    public static void register() {
        CapabilityManager.INSTANCE.register(InfraredReceiver.class, (Capability.IStorage)new Capability.IStorage<InfraredReceiver>(){

            @Nullable
            public NBTBase writeNBT(Capability<InfraredReceiver> capability, InfraredReceiver instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<InfraredReceiver> capability, InfraredReceiver instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> DEFAULT_INFRARED_RECEIVER);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void onAttachTileEntityCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity tileEntity = (TileEntity)event.getObject();
        if (tileEntity instanceof InfraredReceiver) {
            event.addCapability(INFRARED_RECEIVER_LOCATION, (ICapabilityProvider)new InfraredReceiverCapabilityProvider((InfraredReceiver)tileEntity));
        }
    }

    @SubscribeEvent
    public void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof InfraredReceiver) {
            event.addCapability(INFRARED_RECEIVER_LOCATION, (ICapabilityProvider)new InfraredReceiverCapabilityProvider((InfraredReceiver)entity));
        }
    }

    private CapabilityInfraredReceiver() {
    }

    static {
        INSTANCE = new CapabilityInfraredReceiver();
        DEFAULT_INFRARED_RECEIVER = new DefaultInfraredReceiver();
    }

    private static class DefaultInfraredReceiver
    implements InfraredReceiver {
        private DefaultInfraredReceiver() {
        }

        @Override
        public void onInfraredPacket(InfraredPacket packet, RayTraceResult hit) {
        }
    }

    private static final class InfraredReceiverCapabilityProvider
    implements ICapabilityProvider {
        private final InfraredReceiver receiver;

        InfraredReceiverCapabilityProvider(InfraredReceiver receiver) {
            this.receiver = receiver;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == INFRARED_RECEIVER_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == INFRARED_RECEIVER_CAPABILITY ? this.receiver : null);
        }
    }
}

