/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import li.cil.tis3d.common.entity.EntityInfraredPacket;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class TickHandlerInfraredPacket {
    public static final TickHandlerInfraredPacket INSTANCE = new TickHandlerInfraredPacket();
    private final Set<EntityInfraredPacket> livePackets = new HashSet<EntityInfraredPacket>();
    private final List<EntityInfraredPacket> pendingRemovals = new ArrayList<EntityInfraredPacket>();
    private final List<EntityInfraredPacket> pendingAdds = new ArrayList<EntityInfraredPacket>();

    public void watchPacket(EntityInfraredPacket packet) {
        this.pendingRemovals.remove(packet);
        this.pendingAdds.add(packet);
    }

    public void unwatchPacket(EntityInfraredPacket packet) {
        this.pendingAdds.remove(packet);
        this.pendingRemovals.add(packet);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.livePackets.addAll(this.pendingAdds);
        this.pendingAdds.clear();
        this.livePackets.removeAll(this.pendingRemovals);
        this.pendingRemovals.clear();
        this.livePackets.forEach(EntityInfraredPacket::updateLifetime);
    }

    private TickHandlerInfraredPacket() {
    }
}

