/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleRotatable;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.util.ColorUtils;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModuleDisplay
extends AbstractModuleRotatable {
    private final int[] image = new int[1024];
    private State state = State.COLOR;
    private final byte[] drawCall = new byte[State.values().length];
    private static final int RESOLUTION = 32;
    private static final int MARGIN = 2;
    private static final String TAG_IMAGE = "image";
    private static final String TAG_STATE = "state";
    private static final String TAG_DRAW_CALL = "drawCall";
    private static final byte DATA_TYPE_CLEAR = 0;
    private int glTextureId;

    public ModuleDisplay(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        for (Port port : Port.VALUES) {
            this.stepInput(port);
        }
    }

    @Override
    public void onDisabled() {
        Arrays.fill(this.image, 0);
        this.state = State.COLOR;
        this.sendClear();
    }

    @Override
    public void onDisposed() {
        World world = this.getCasing().getCasingWorld();
        if (world.field_72995_K) {
            this.deleteTexture();
        }
    }

    @Override
    public void onData(ByteBuf data) {
        if (data.readBoolean()) {
            Arrays.fill(this.image, 0);
        } else {
            data.readBytes(this.drawCall);
            this.applyDrawCall(this.drawCall);
        }
        TextureUtil.func_110988_a((int)this.getGlTextureId(), (int[])this.image, (int)32, (int)32);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled) {
            return;
        }
        this.rotateForRendering();
        RenderUtil.ignoreLighting();
        GlStateManager.func_179144_i((int)this.getGlTextureId());
        RenderUtil.drawQuad();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        int[] imageNbt = nbt.func_74759_k(TAG_IMAGE);
        System.arraycopy(imageNbt, 0, this.image, 0, Math.min(imageNbt.length, this.image.length));
        this.state = EnumUtils.readFromNBT(State.class, TAG_STATE, nbt);
        byte[] drawCallNbt = nbt.func_74770_j(TAG_DRAW_CALL);
        System.arraycopy(drawCallNbt, 0, this.drawCall, 0, Math.min(drawCallNbt.length, this.drawCall.length));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74783_a(TAG_IMAGE, this.image);
        EnumUtils.writeToNBT(this.state, TAG_STATE, nbt);
        nbt.func_74773_a(TAG_DRAW_CALL, (byte[])this.drawCall.clone());
    }

    private void stepInput(Port port) {
        Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
        if (!receivingPipe.isReading()) {
            receivingPipe.beginRead();
        }
        if (receivingPipe.canTransfer()) {
            this.process(receivingPipe.read());
        }
    }

    private void process(short value) {
        this.drawCall[this.state.ordinal()] = (byte)value;
        this.state = this.state.getNext();
        if (this.state == State.COLOR) {
            this.applyDrawCall(this.drawCall);
            this.sendDrawCall();
        }
    }

    private void applyDrawCall(byte[] drawCall) {
        byte color = drawCall[State.COLOR.ordinal()];
        byte xin = drawCall[State.X.ordinal()];
        byte yin = drawCall[State.Y.ordinal()];
        byte w = drawCall[State.W.ordinal()];
        byte h = drawCall[State.H.ordinal()];
        int x0 = 2 + Math.max(0, xin);
        int x1 = 2 + Math.min(28, xin + w);
        int y0 = 2 + Math.max(0, yin);
        int y1 = 2 + Math.min(28, yin + h);
        for (int y = y0; y < y1; ++y) {
            int offset = y * 32;
            for (int x = x0; x < x1; ++x) {
                int index = offset + x;
                this.image[index] = ColorUtils.getColorByIndex(Math.max(0, color));
            }
        }
    }

    private int getGlTextureId() {
        if (this.glTextureId == 0) {
            this.glTextureId = GlStateManager.func_179146_y();
            TextureUtil.func_110991_a((int)this.glTextureId, (int)32, (int)32);
            TextureUtil.func_110988_a((int)this.glTextureId, (int[])this.image, (int)32, (int)32);
        }
        return this.glTextureId;
    }

    private void deleteTexture() {
        if (this.glTextureId != 0) {
            TextureUtil.func_147942_a((int)this.glTextureId);
            this.glTextureId = 0;
        }
    }

    private void sendClear() {
        ByteBuf data = Unpooled.buffer();
        data.writeBoolean(true);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    private void sendDrawCall() {
        ByteBuf data = Unpooled.buffer();
        data.writeBoolean(false);
        data.writeBytes(this.drawCall);
        this.getCasing().sendData(this.getFace(), data);
    }

    private static enum State {
        COLOR,
        X,
        Y,
        W,
        H;

        public static final State[] VALUES;

        public State getNext() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        static {
            VALUES = State.values();
        }
    }
}

