/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.traits.BlockChangeAware;
import li.cil.tis3d.api.module.traits.CasingFaceQuadOverride;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.util.BlockStateUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModuleFacade
extends AbstractModule
implements BlockChangeAware,
CasingFaceQuadOverride {
    private IBlockState facadeState;
    private static final byte DATA_TYPE_FULL = 0;

    public ModuleFacade(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, float hitX, float hitY, float hitZ) {
        if (this.getCasing().isLocked()) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return false;
        }
        IBlockState state = BlockStateUtils.getBlockStateFromItemStack(stack);
        if (state == null) {
            return false;
        }
        if (!this.trySetFacadeState(state) && !this.getCasing().getCasingWorld().field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("tis3d.facade.invalid_target", new Object[0]));
        }
        return true;
    }

    @Override
    public void onData(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
        World world = this.getCasing().getCasingWorld();
        BlockPos position = this.getCasing().getPosition();
        IBlockState state = world.func_180495_p(position);
        world.func_184138_a(position, state, state, 1);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.facadeState = NBTUtil.func_190008_d((NBTTagCompound)nbt);
        if (this.facadeState == Blocks.field_150350_a.func_176223_P()) {
            this.facadeState = null;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.facadeState != null) {
            NBTUtil.func_190009_a((NBTTagCompound)nbt, (IBlockState)this.facadeState);
        }
    }

    @Override
    public void onNeighborBlockChange(BlockPos neighborPos, boolean isModuleNeighbor) {
        if (!isModuleNeighbor) {
            return;
        }
        if (this.getCasing().isLocked()) {
            return;
        }
        this.trySetFacadeState(this.getCasing().getCasingWorld().func_180495_p(neighborPos));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getCasingFaceQuads(@Nullable IBlockState state, EnumFacing side, long randomSeed) {
        if (this.facadeState == null) {
            return null;
        }
        BlockModelShapes shapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        return shapes.func_178125_b(this.facadeState).func_188616_a(this.facadeState, side, randomSeed);
    }

    private boolean trySetFacadeState(IBlockState state) {
        if (state.func_185901_i() != EnumBlockRenderType.MODEL || !state.func_185914_p() || state.func_177230_c().hasTileEntity(state)) {
            return false;
        }
        if (!this.getCasing().getCasingWorld().field_72995_K) {
            this.facadeState = state;
            this.sendState();
        }
        return true;
    }

    private void sendState() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        this.getCasing().sendData(this.getFace(), nbt, (byte)0);
    }
}

