/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.api.prefab.module.AbstractModuleRotatable;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.renderer.TextureLoader;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModuleRedstone
extends AbstractModuleRotatable
implements Redstone {
    private short output = 0;
    private short input = 0;
    private static final String TAG_OUTPUT = "output";
    private static final String TAG_INPUT = "input";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final float LEFT_U0 = 0.28125f;
    private static final float LEFT_U1 = 0.375f;
    private static final float RIGHT_U0 = 0.625f;
    private static final float RIGHT_U1 = 0.71875f;
    private static final float SHARED_V0 = 0.3125f;
    private static final float SHARED_V1 = 0.78125f;
    private static final float SHARED_W = 0.09375f;
    private static final float SHARED_H = 0.46875f;
    private long lastStep = 0L;
    private boolean scheduledNeighborUpdate = false;

    public ModuleRedstone(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        World world = this.getCasing().getCasingWorld();
        for (Port port : Port.VALUES) {
            this.stepOutput(port);
            this.stepInput(port);
        }
        if (this.scheduledNeighborUpdate && world.func_82737_E() > this.lastStep) {
            this.notifyNeighbors();
        }
        this.lastStep = world.func_82737_E();
    }

    @Override
    public void onDisabled() {
        this.input = 0;
        this.output = 0;
        this.notifyNeighbors();
        this.sendData();
    }

    @Override
    public void onEnabled() {
        this.sendData();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.stepOutput(port);
    }

    @Override
    public void onData(ByteBuf data) {
        this.input = data.readShort();
        this.output = data.readShort();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        this.rotateForRendering();
        RenderUtil.ignoreLighting();
        RenderUtil.drawQuad(RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_MODULE_REDSTONE));
        if (!enabled) {
            return;
        }
        TextureAtlasSprite barsSprite = RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_MODULE_REDSTONE_BARS);
        float relativeOutput = (float)this.output / 15.0f;
        float heightOutput = relativeOutput * 0.46875f;
        float v0Output = 0.78125f - heightOutput;
        RenderUtil.drawQuad(barsSprite, 0.28125f, v0Output, 0.09375f, heightOutput, 0.28125f, v0Output, 0.375f, 0.78125f);
        float relativeInput = (float)this.input / 15.0f;
        float heightInput = relativeInput * 0.46875f;
        float v0Input = 0.78125f - heightInput;
        RenderUtil.drawQuad(barsSprite, 0.625f, v0Input, 0.09375f, heightInput, 0.625f, v0Input, 0.71875f, 0.78125f);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.output = (short)Math.max(0, Math.min(15, nbt.func_74765_d(TAG_OUTPUT)));
        this.input = (short)Math.max(0, Math.min(15, nbt.func_74765_d(TAG_INPUT)));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a(TAG_OUTPUT, (int)this.output);
        nbt.func_74768_a(TAG_INPUT, (int)this.input);
    }

    @Override
    public short getRedstoneOutput() {
        return this.output;
    }

    @Override
    public void setRedstoneInput(short value) {
        World world = this.getCasing().getCasingWorld();
        if (world.field_72995_K) {
            return;
        }
        short validatedValue = (short)Math.max(0, Math.min(15, value));
        if (validatedValue == this.input) {
            return;
        }
        this.input = validatedValue;
        this.getCasing().markDirty();
        this.cancelWrite();
        this.sendData();
    }

    private void stepOutput(Port port) {
        Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
        if (!sendingPipe.isWriting()) {
            sendingPipe.beginWrite(this.input);
        }
    }

    private void stepInput(Port port) {
        Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
        if (!receivingPipe.isReading()) {
            receivingPipe.beginRead();
        }
        if (receivingPipe.canTransfer()) {
            this.setRedstoneOutput(receivingPipe.read());
        }
    }

    private void setRedstoneOutput(short value) {
        short validatedValue = (short)Math.max(0, Math.min(15, value));
        if (validatedValue == this.output) {
            return;
        }
        this.output = validatedValue;
        this.getCasing().markDirty();
        this.scheduledNeighborUpdate = true;
        this.sendData();
    }

    private void notifyNeighbors() {
        World world = this.getCasing().getCasingWorld();
        this.scheduledNeighborUpdate = false;
        Block blockType = world.func_180495_p(this.getCasing().getPosition()).func_177230_c();
        world.func_175685_c(this.getCasing().getPosition(), blockType, false);
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeShort((int)this.input);
        data.writeShort((int)this.output);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }
}

