/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import java.util.Optional;
import li.cil.tis3d.api.SerialAPI;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.BlockChangeAware;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.serial.SerialInterface;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.renderer.TextureLoader;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModuleSerialPort
extends AbstractModule
implements BlockChangeAware {
    private short writing;
    private static final String TAG_VALUE = "value";
    private static final String TAG_SERIAL_INTERFACE = "serialInterface";
    private Optional<SerialInterface> serialInterface = Optional.empty();
    private Optional<NBTTagCompound> serialInterfaceNbt = Optional.empty();
    private boolean isScanScheduled = true;

    public ModuleSerialPort(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void onNeighborBlockChange(BlockPos neighborPos, boolean isModuleNeighbor) {
        if (isModuleNeighbor) {
            this.isScanScheduled = true;
        }
    }

    @Override
    public void step() {
        this.scan();
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        this.serialInterface.ifPresent(SerialInterface::reset);
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.serialInterface.ifPresent(SerialInterface::skip);
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled) {
            return;
        }
        RenderUtil.ignoreLighting();
        RenderUtil.drawQuad(RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_MODULE_SERIAL_PORT));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.writing = nbt.func_74765_d(TAG_VALUE);
        if (nbt.func_74764_b(TAG_SERIAL_INTERFACE)) {
            if (this.serialInterface.isPresent()) {
                this.serialInterface.get().readFromNBT(nbt.func_74775_l(TAG_SERIAL_INTERFACE));
            } else {
                this.serialInterfaceNbt = Optional.of(nbt.func_74775_l(TAG_SERIAL_INTERFACE));
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74777_a(TAG_VALUE, this.writing);
        if (this.serialInterface.isPresent()) {
            NBTTagCompound serialInterfaceNbt = new NBTTagCompound();
            this.serialInterface.get().writeToNBT(serialInterfaceNbt);
            if (!nbt.func_82582_d()) {
                nbt.func_74782_a(TAG_SERIAL_INTERFACE, (NBTBase)serialInterfaceNbt);
            }
        }
    }

    private void scan() {
        if (!this.isScanScheduled) {
            return;
        }
        this.isScanScheduled = false;
        World world = this.getCasing().getCasingWorld();
        BlockPos neighborPos = this.getCasing().getPosition().func_177972_a(Face.toEnumFacing(this.getFace()));
        EnumFacing neighborSide = Face.toEnumFacing(this.getFace().getOpposite());
        if (world.func_175667_e(neighborPos)) {
            SerialInterfaceProvider provider = SerialAPI.getProviderFor(world, neighborPos, neighborSide);
            if (provider != null) {
                if (!this.serialInterface.map(s -> provider.isValid(world, neighborPos, neighborSide, (SerialInterface)s)).orElse(false).booleanValue()) {
                    this.reset();
                    this.serialInterface = Optional.ofNullable(provider.interfaceFor(world, neighborPos, neighborSide));
                    if (this.serialInterface.isPresent() && this.serialInterfaceNbt.isPresent()) {
                        this.serialInterface.get().readFromNBT(this.serialInterfaceNbt.get());
                        this.serialInterfaceNbt = Optional.empty();
                    }
                }
            } else {
                this.reset();
            }
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.serialInterface.ifPresent(SerialInterface::reset);
        this.serialInterface = Optional.empty();
        this.cancelRead();
        this.cancelWrite();
    }

    private void stepOutput() {
        if (this.serialInterface.map(SerialInterface::canRead).orElse(false).booleanValue()) {
            short value = this.serialInterface.map(SerialInterface::peek).orElse((short)0);
            if (value != this.writing) {
                this.cancelWrite();
                this.writing = value;
            }
            for (Port port : Port.VALUES) {
                Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
                if (sendingPipe.isWriting()) continue;
                sendingPipe.beginWrite(this.writing);
            }
        } else {
            this.cancelWrite();
        }
    }

    private void stepInput() {
        if (this.serialInterface.map(SerialInterface::canWrite).orElse(false).booleanValue()) {
            for (Port port : Port.VALUES) {
                Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
                if (!receivingPipe.isReading()) {
                    receivingPipe.beginRead();
                }
                if (!receivingPipe.canTransfer()) continue;
                this.serialInterface.ifPresent(s -> s.write(receivingPipe.read()));
            }
        } else {
            this.cancelRead();
        }
    }
}

