/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.module.ModuleExecution;
import li.cil.tis3d.common.module.execution.Machine;
import li.cil.tis3d.common.module.execution.MachineState;
import li.cil.tis3d.common.module.execution.instruction.Instruction;
import li.cil.tis3d.common.module.execution.target.Target;
import li.cil.tis3d.common.module.execution.target.TargetInterface;
import li.cil.tis3d.common.module.execution.target.TargetInterfaceAcc;
import li.cil.tis3d.common.module.execution.target.TargetInterfaceAny;
import li.cil.tis3d.common.module.execution.target.TargetInterfaceBak;
import li.cil.tis3d.common.module.execution.target.TargetInterfaceLast;
import li.cil.tis3d.common.module.execution.target.TargetInterfaceNil;
import li.cil.tis3d.common.module.execution.target.TargetInterfaceSide;

public final class MachineImpl
implements Machine {
    private final MachineState state = new MachineState();
    private final ModuleExecution module;
    private final Map<Target, TargetInterface> interfaces;

    public MachineImpl(ModuleExecution module, Face face) {
        this.module = module;
        this.interfaces = ImmutableMap.builder().put((Object)Target.ACC, (Object)new TargetInterfaceAcc(this)).put((Object)Target.BAK, (Object)new TargetInterfaceBak(this)).put((Object)Target.NIL, (Object)new TargetInterfaceNil(this)).put((Object)Target.LEFT, (Object)new TargetInterfaceSide(this, module, face, Port.LEFT)).put((Object)Target.RIGHT, (Object)new TargetInterfaceSide(this, module, face, Port.RIGHT)).put((Object)Target.UP, (Object)new TargetInterfaceSide(this, module, face, Port.UP)).put((Object)Target.DOWN, (Object)new TargetInterfaceSide(this, module, face, Port.DOWN)).put((Object)Target.ANY, (Object)new TargetInterfaceAny(this, module, face)).put((Object)Target.LAST, (Object)new TargetInterfaceLast(this, module, face)).build();
    }

    public boolean step() {
        Instruction instruction = this.getInstruction();
        if (instruction != null) {
            instruction.step(this);
        }
        return this.state.finishCycle();
    }

    public void onBeforeWriteComplete(Port port) {
        Instruction instruction = this.getInstruction();
        if (instruction != null) {
            instruction.onBeforeWriteComplete(this, port);
        }
    }

    public void onWriteCompleted(Port port) {
        Instruction instruction = this.getInstruction();
        if (instruction != null) {
            instruction.onWriteCompleted(this, port);
        }
    }

    @Nullable
    private Instruction getInstruction() {
        if (this.state.pc >= 0 && this.state.pc < this.state.instructions.size()) {
            return this.state.instructions.get(this.state.pc);
        }
        return null;
    }

    @Override
    public MachineState getState() {
        return this.state;
    }

    @Override
    public TargetInterface getInterface(Target target) {
        Target rotatedTarget = this.getRotatedTarget(target);
        return this.interfaces.get((Object)rotatedTarget);
    }

    private Target getRotatedTarget(Target target) {
        switch (target) {
            case LEFT: 
            case RIGHT: 
            case UP: 
            case DOWN: {
                int rotation = Port.ROTATION[this.module.getFacing().ordinal()];
                if (this.module.getFace() == Face.Y_NEG) {
                    rotation = -rotation;
                }
                Port port = Target.toPort(target);
                Port rotatedPort = port.rotated(rotation);
                return Target.fromPort(rotatedPort);
            }
        }
        return target;
    }
}

