/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.module.execution.compiler.Compiler;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.instruction.Instruction;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.nbt.NBTTagCompound;

public final class MachineState {
    public int pc = 0;
    public short acc = 0;
    public short bak = 0;
    public Optional<Port> last = Optional.empty();
    public String[] code;
    private int pcPrev;
    private static final String TAG_CODE = "code";
    private static final String TAG_PC = "pc";
    private static final String TAG_ACC = "acc";
    private static final String TAG_BAK = "bak";
    private static final String TAG_LAST = "last";
    private static final String TAG_PC_PREV = "pcPrev";
    public final List<Instruction> instructions = new ArrayList<Instruction>(Settings.maxLinesPerProgram);
    public final HashMap<String, Integer> labels = new HashMap(Settings.maxLinesPerProgram);
    public final HashMap<Integer, Integer> lineNumbers = new HashMap(Settings.maxLinesPerProgram);

    public boolean finishCycle() {
        boolean hasChanged;
        boolean bl = hasChanged = this.pc != this.pcPrev;
        if (this.pc < 0 || this.pc >= this.instructions.size()) {
            this.pc = 0;
        }
        this.pcPrev = this.pc;
        return hasChanged;
    }

    public void reset() {
        this.pc = 0;
        this.acc = 0;
        this.bak = 0;
        this.last = Optional.empty();
    }

    public void clear() {
        this.reset();
        this.instructions.clear();
        this.labels.clear();
        this.code = null;
        this.lineNumbers.clear();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(TAG_CODE)) {
            try {
                Compiler.compile(Arrays.asList(Constants.PATTERN_LINES.split(nbt.func_74779_i(TAG_CODE))), this);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.pc = nbt.func_74762_e(TAG_PC);
        this.acc = nbt.func_74765_d(TAG_ACC);
        this.bak = nbt.func_74765_d(TAG_BAK);
        this.last = nbt.func_74764_b(TAG_LAST) ? Optional.of(EnumUtils.readFromNBT(Port.class, TAG_LAST, nbt)) : Optional.empty();
        this.pcPrev = nbt.func_74762_e(TAG_PC_PREV);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a(TAG_PC, this.pc);
        nbt.func_74777_a(TAG_ACC, this.acc);
        nbt.func_74777_a(TAG_BAK, this.bak);
        this.last.ifPresent(port -> EnumUtils.writeToNBT(port, TAG_LAST, nbt));
        nbt.func_74768_a(TAG_PC_PREV, this.pcPrev);
        if (this.code != null) {
            nbt.func_74778_a(TAG_CODE, String.join((CharSequence)"\n", this.code));
        }
    }
}

