/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution.compiler;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.module.execution.MachineState;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.compiler.Validator;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitter;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitterLabel;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitterMissing;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitterMove;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitterTargetOrImmediate;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitterUnary;
import li.cil.tis3d.common.module.execution.instruction.Instruction;
import li.cil.tis3d.common.module.execution.instruction.InstructionAdd;
import li.cil.tis3d.common.module.execution.instruction.InstructionAddImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseAnd;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseAndImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseNot;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseOr;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseOrImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseShiftLeft;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseShiftLeftImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseShiftRight;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseShiftRightImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseXor;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseXorImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionDiv;
import li.cil.tis3d.common.module.execution.instruction.InstructionDivImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionHaltAndCatchFire;
import li.cil.tis3d.common.module.execution.instruction.InstructionJump;
import li.cil.tis3d.common.module.execution.instruction.InstructionJumpEqualZero;
import li.cil.tis3d.common.module.execution.instruction.InstructionJumpGreaterThanZero;
import li.cil.tis3d.common.module.execution.instruction.InstructionJumpLessThanZero;
import li.cil.tis3d.common.module.execution.instruction.InstructionJumpNotZero;
import li.cil.tis3d.common.module.execution.instruction.InstructionJumpRelative;
import li.cil.tis3d.common.module.execution.instruction.InstructionJumpRelativeImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionLastRotateLeft;
import li.cil.tis3d.common.module.execution.instruction.InstructionLastRotateRight;
import li.cil.tis3d.common.module.execution.instruction.InstructionMul;
import li.cil.tis3d.common.module.execution.instruction.InstructionMulImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionNegate;
import li.cil.tis3d.common.module.execution.instruction.InstructionSave;
import li.cil.tis3d.common.module.execution.instruction.InstructionSubtract;
import li.cil.tis3d.common.module.execution.instruction.InstructionSubtractImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionSwap;
import li.cil.tis3d.common.module.execution.target.Target;

public final class Compiler {
    private static final Pattern PATTERN_COMMENT = Pattern.compile("#.*$");
    private static final Pattern PATTERN_DEFINE = Pattern.compile("#DEFINE\\s+(?<key>\\S+)\\s*(?<value>\\S+)\\s*$");
    private static final Pattern PATTERN_UNDEFINE = Pattern.compile("#UNDEF\\s+(?<key>\\S+)\\s*$");
    private static final Pattern PATTERN_LINE = Pattern.compile("^\\s*(?:(?<label>[^:\\s]+)\\s*:\\s*)?(?:(?<name>\\S+)\\s*(?<arg1>[^,\\s]+)?\\s*,?\\s*(?<arg2>[^,\\s]+)?\\s*(?<excess>.+)?)?\\s*$");
    private static final String INSTRUCTION_NO_NAME = "NOP";
    private static final Instruction INSTRUCTION_NOP = new InstructionAdd(Target.NIL);
    private static final InstructionEmitter EMITTER_MISSING = new InstructionEmitterMissing();
    private static final Map<String, InstructionEmitter> EMITTER_MAP;

    public static void compile(Iterable<String> code, MachineState state) throws ParseException {
        state.clear();
        String[] lines = (String[])Iterables.toArray(code, String.class);
        if (lines.length > Settings.maxLinesPerProgram) {
            throw new ParseException("tis3d.compiler.too_many_lines", Settings.maxLinesPerProgram, 0, 0);
        }
        for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
            lines[lineNumber] = lines[lineNumber].toUpperCase(Locale.US);
        }
        state.code = lines;
        try {
            ArrayList<Validator> validators = new ArrayList<Validator>();
            HashMap<String, String> defines = new HashMap<String, String>();
            for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
                Matcher commentMatcher;
                String line;
                Matcher lineMatcher;
                Matcher undefineMatcher;
                if (lines[lineNumber].length() > Settings.maxColumnsPerLine) {
                    throw new ParseException("tis3d.compiler.too_many_columns", lineNumber, Settings.maxColumnsPerLine, Settings.maxColumnsPerLine);
                }
                Matcher defineMatcher = PATTERN_DEFINE.matcher(lines[lineNumber]);
                if (defineMatcher.matches()) {
                    Compiler.parseDefine(defineMatcher, defines);
                }
                if ((undefineMatcher = PATTERN_UNDEFINE.matcher(lines[lineNumber])).matches()) {
                    Compiler.parseUndefine(undefineMatcher, defines);
                }
                if (!(lineMatcher = PATTERN_LINE.matcher(line = (commentMatcher = PATTERN_COMMENT.matcher(lines[lineNumber])).replaceFirst("").trim())).matches()) {
                    throw new ParseException("tis3d.compiler.invalid_format", lineNumber, 0, 0);
                }
                Compiler.parseLabel(lineMatcher, state, lineNumber);
                Compiler.parseInstruction(lineMatcher, state, lineNumber, defines, validators);
            }
            for (Validator validator : validators) {
                validator.accept(state);
            }
        }
        catch (ParseException e) {
            state.clear();
            state.code = lines;
            throw e;
        }
    }

    private static void parseDefine(Matcher matcher, Map<String, String> defines) {
        String key = matcher.group("key");
        if (key == null) {
            return;
        }
        String value = matcher.group("value");
        if (value == null) {
            return;
        }
        if (key.equals(value)) {
            return;
        }
        if (defines.containsKey(value)) {
            value = defines.get(value);
        }
        defines.put(key, value);
    }

    private static void parseUndefine(Matcher matcher, Map<String, String> defines) {
        String key = matcher.group("key");
        if (key == null) {
            return;
        }
        defines.remove(key);
    }

    private static void parseLabel(Matcher matcher, MachineState state, int lineNumber) throws ParseException {
        String label = matcher.group("label");
        if (label == null) {
            return;
        }
        if (state.labels.containsKey(label)) {
            throw new ParseException("tis3d.compiler.label_duplicate", lineNumber, matcher.start("label"), matcher.end("label"));
        }
        state.labels.put(label, state.instructions.size());
    }

    private static void parseInstruction(Matcher matcher, MachineState state, int lineNumber, Map<String, String> defines, List<Validator> validators) throws ParseException {
        String name = matcher.group("name");
        if (name == null) {
            return;
        }
        Instruction instruction = EMITTER_MAP.getOrDefault(name, EMITTER_MISSING).compile(matcher, lineNumber, defines, validators);
        state.lineNumbers.put(state.instructions.size(), lineNumber);
        state.instructions.add(instruction);
    }

    private Compiler() {
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)INSTRUCTION_NO_NAME, (Object)new InstructionEmitterUnary(() -> INSTRUCTION_NOP));
        builder.put((Object)"HCF", (Object)new InstructionEmitterUnary(() -> InstructionHaltAndCatchFire.INSTANCE));
        builder.put((Object)"JMP", (Object)new InstructionEmitterLabel(InstructionJump::new));
        builder.put((Object)"JEZ", (Object)new InstructionEmitterLabel(InstructionJumpEqualZero::new));
        builder.put((Object)"JGZ", (Object)new InstructionEmitterLabel(InstructionJumpGreaterThanZero::new));
        builder.put((Object)"JLZ", (Object)new InstructionEmitterLabel(InstructionJumpLessThanZero::new));
        builder.put((Object)"JNZ", (Object)new InstructionEmitterLabel(InstructionJumpNotZero::new));
        builder.put((Object)"JRO", (Object)new InstructionEmitterTargetOrImmediate(InstructionJumpRelative::new, InstructionJumpRelativeImmediate::new));
        builder.put((Object)"MOV", (Object)new InstructionEmitterMove());
        builder.put((Object)"SAV", (Object)new InstructionEmitterUnary(() -> InstructionSave.INSTANCE));
        builder.put((Object)"SWP", (Object)new InstructionEmitterUnary(() -> InstructionSwap.INSTANCE));
        builder.put((Object)"NEG", (Object)new InstructionEmitterUnary(() -> InstructionNegate.INSTANCE));
        builder.put((Object)"ADD", (Object)new InstructionEmitterTargetOrImmediate(InstructionAdd::new, InstructionAddImmediate::new));
        builder.put((Object)"SUB", (Object)new InstructionEmitterTargetOrImmediate(InstructionSubtract::new, InstructionSubtractImmediate::new));
        builder.put((Object)"MUL", (Object)new InstructionEmitterTargetOrImmediate(InstructionMul::new, InstructionMulImmediate::new));
        builder.put((Object)"DIV", (Object)new InstructionEmitterTargetOrImmediate(InstructionDiv::new, InstructionDivImmediate::new));
        builder.put((Object)"NOT", (Object)new InstructionEmitterUnary(() -> InstructionBitwiseNot.INSTANCE));
        builder.put((Object)"AND", (Object)new InstructionEmitterTargetOrImmediate(InstructionBitwiseAnd::new, InstructionBitwiseAndImmediate::new));
        builder.put((Object)"OR", (Object)new InstructionEmitterTargetOrImmediate(InstructionBitwiseOr::new, InstructionBitwiseOrImmediate::new));
        builder.put((Object)"XOR", (Object)new InstructionEmitterTargetOrImmediate(InstructionBitwiseXor::new, InstructionBitwiseXorImmediate::new));
        builder.put((Object)"SHL", (Object)new InstructionEmitterTargetOrImmediate(InstructionBitwiseShiftLeft::new, InstructionBitwiseShiftLeftImmediate::new));
        builder.put((Object)"SHR", (Object)new InstructionEmitterTargetOrImmediate(InstructionBitwiseShiftRight::new, InstructionBitwiseShiftRightImmediate::new));
        builder.put((Object)"RLLAST", (Object)new InstructionEmitterUnary(() -> InstructionLastRotateLeft.INSTANCE));
        builder.put((Object)"RRLAST", (Object)new InstructionEmitterUnary(() -> InstructionLastRotateRight.INSTANCE));
        EMITTER_MAP = builder.build();
    }
}

