/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution.compiler.instruction;

import java.util.Map;
import java.util.regex.Matcher;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitter;
import li.cil.tis3d.common.module.execution.target.Target;

abstract class AbstractInstructionEmitter
implements InstructionEmitter {
    AbstractInstructionEmitter() {
    }

    static void checkExcess(int lineNumber, Matcher matcher, String name) throws ParseException {
        int start = matcher.start(name);
        if (start >= 0) {
            throw new ParseException("tis3d.compiler.parameter_overflow", lineNumber, start, matcher.end());
        }
    }

    static String checkArg(int lineNumber, Matcher matcher, String name, String previous) throws ParseException {
        String arg = matcher.group(name);
        if (arg == null) {
            throw new ParseException("tis3d.compiler.parameter_underflow", lineNumber, matcher.end(previous) + 1, matcher.end(previous) + 1);
        }
        return arg;
    }

    static Target checkTarget(String name, int lineNumber, Map<String, String> defines, int start, int end) throws ParseException {
        name = defines.getOrDefault(name, name);
        try {
            Target target = Enum.valueOf(Target.class, name);
            if (!Target.VALID_TARGETS.contains((Object)target)) {
                throw new ParseException("tis3d.compiler.parameter_invalid", lineNumber, start, end);
            }
            return target;
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException("tis3d.compiler.parameter_invalid", lineNumber, start, end);
        }
    }

    static Object checkTargetOrNumber(String name, int lineNumber, Map<String, String> defines, int start, int end) throws ParseException {
        name = defines.getOrDefault(name, name);
        try {
            Target target = Enum.valueOf(Target.class, name);
            if (!Target.VALID_TARGETS.contains((Object)target)) {
                throw new ParseException("tis3d.compiler.parameter_invalid", lineNumber, start, end);
            }
            return target;
        }
        catch (IllegalArgumentException ex) {
            try {
                return Integer.decode(name).shortValue();
            }
            catch (NumberFormatException ignored) {
                throw new ParseException("tis3d.compiler.parameter_invalid", lineNumber, start, end);
            }
        }
    }
}

