/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.message;

import io.netty.buffer.ByteBuf;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.network.message.AbstractMessageWithLocation;
import li.cil.tis3d.common.tileentity.TileEntityCasing;

public final class MessageReceivingPipeLockedState
extends AbstractMessageWithLocation {
    private Face face;
    private Port port;
    private boolean isLocked;

    public MessageReceivingPipeLockedState(TileEntityCasing casing, Face face, Port port, boolean isLocked) {
        super(casing.func_145831_w(), casing.func_174877_v());
        this.face = face;
        this.port = port;
        this.isLocked = isLocked;
    }

    public MessageReceivingPipeLockedState() {
    }

    public Face getFace() {
        return this.face;
    }

    public Port getPort() {
        return this.port;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        byte compressed = buf.readByte();
        this.face = Face.VALUES[compressed >>> 3 & 7];
        this.port = Port.VALUES[compressed >>> 1 & 3];
        this.isLocked = (compressed & 1) == 1;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        byte compressed = (byte)(this.face.ordinal() << 3 | this.port.ordinal() << 1 | (this.isLocked ? 1 : 0));
        buf.writeByte((int)compressed);
    }
}

