/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.gui;

import com.feed_the_beast.ftblib.lib.config.ConfigDouble;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftblib.lib.gui.SimpleButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WrappedIngredient;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfig;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfigValue;
import com.feed_the_beast.ftblib.lib.gui.misc.IConfigValueEditCallback;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconWithOutline;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.item.ItemEntryWithCount;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.net.MessageEditNBTResponse;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;

public class GuiEditNBT
extends GuiBase {
    public static final Icon NBT_BYTE = GuiEditNBT.getIcon("byte");
    public static final Icon NBT_SHORT = GuiEditNBT.getIcon("short");
    public static final Icon NBT_INT = GuiEditNBT.getIcon("int");
    public static final Icon NBT_LONG = GuiEditNBT.getIcon("long");
    public static final Icon NBT_FLOAT = GuiEditNBT.getIcon("float");
    public static final Icon NBT_DOUBLE = GuiEditNBT.getIcon("double");
    public static final Icon NBT_STRING = GuiEditNBT.getIcon("string");
    public static final Icon NBT_LIST = GuiEditNBT.getIcon("list");
    public static final Icon NBT_LIST_CLOSED = GuiEditNBT.getIcon("list_closed");
    public static final Icon NBT_LIST_OPEN = GuiEditNBT.getIcon("list_open");
    public static final Icon NBT_MAP = GuiEditNBT.getIcon("map");
    public static final Icon NBT_MAP_CLOSED = GuiEditNBT.getIcon("map_closed");
    public static final Icon NBT_MAP_OPEN = GuiEditNBT.getIcon("map_open");
    public static final Icon NBT_BYTE_ARRAY = GuiEditNBT.getIcon("byte_array");
    public static final Icon NBT_BYTE_ARRAY_CLOSED = GuiEditNBT.getIcon("byte_array_closed");
    public static final Icon NBT_BYTE_ARRAY_OPEN = GuiEditNBT.getIcon("byte_array_open");
    public static final Icon NBT_INT_ARRAY = GuiEditNBT.getIcon("int_array");
    public static final Icon NBT_INT_ARRAY_CLOSED = GuiEditNBT.getIcon("int_array_closed");
    public static final Icon NBT_INT_ARRAY_OPEN = GuiEditNBT.getIcon("int_array_open");
    private final NBTTagCompound info;
    private final ButtonNBTMap buttonNBTRoot;
    private ButtonNBT selected;
    public final Panel panelTopLeft;
    public final Panel panelTopRight;
    public final Panel panelNbt;
    public final PanelScrollBar scroll;
    private int shouldClose = 0;

    private static Icon getIcon(String name) {
        return Icon.getIcon((String)("ftbutilities:textures/gui/nbt/" + name + ".png"));
    }

    private ButtonNBT getFrom(ButtonNBTCollection b, String key) {
        NBTBase nbt = b.getTag(key);
        switch (nbt.func_74732_a()) {
            case 10: {
                return new ButtonNBTMap(this.panelNbt, b, key, (NBTTagCompound)nbt);
            }
            case 9: {
                return new ButtonNBTList(this.panelNbt, b, key, (NBTTagList)nbt);
            }
            case 7: {
                return new ButtonNBTByteArray(this.panelNbt, b, key, (NBTTagByteArray)nbt);
            }
            case 11: {
                return new ButtonNBTIntArray(this.panelNbt, b, key, (NBTTagIntArray)nbt);
            }
        }
        return new ButtonNBTPrimitive(this.panelNbt, b, key, nbt);
    }

    public SimpleButton newTag(Panel panel, String t, Icon icon, Supplier<NBTBase> supplier) {
        return new SimpleButton(panel, t, icon, (gui, button) -> {
            if (this.selected instanceof ButtonNBTMap) {
                new GuiEditConfigValue("value", (ConfigValue)new ConfigString("", Pattern.compile("^.+$")), (arg_0, arg_1) -> this.lambda$null$0((Supplier)supplier, arg_0, arg_1)).openGui();
            } else if (this.selected instanceof ButtonNBTCollection) {
                ((ButtonNBTCollection)this.selected).setTag("-1", (NBTBase)supplier.get());
                this.selected.updateChildren(false);
                this.panelNbt.refreshWidgets();
            }
        }){

            public void drawBackground(Theme theme, int x, int y, int w, int h) {
                IconWithOutline.BUTTON_ROUND_GRAY.draw(x, y, w, h);
            }
        };
    }

    public GuiEditNBT(NBTTagCompound i, NBTTagCompound nbt) {
        this.info = i;
        this.panelTopLeft = new Panel((Panel)this){

            public void addWidgets() {
                this.add((Widget)new SimpleButton((Panel)this, I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiEditNBT.this.selected == GuiEditNBT.this.buttonNBTRoot ? GuiIcons.REMOVE_GRAY : GuiIcons.REMOVE, (widget, button) -> {
                    if (GuiEditNBT.this.selected != GuiEditNBT.this.buttonNBTRoot) {
                        ((GuiEditNBT)GuiEditNBT.this).selected.parent.setTag(((GuiEditNBT)GuiEditNBT.this).selected.key, null);
                        ((GuiEditNBT)GuiEditNBT.this).selected.parent.updateChildren(false);
                        GuiEditNBT.this.selected = ((GuiEditNBT)GuiEditNBT.this).selected.parent;
                        GuiEditNBT.this.panelNbt.refreshWidgets();
                        GuiEditNBT.this.panelTopLeft.refreshWidgets();
                    }
                }));
                boolean canRename = ((GuiEditNBT)GuiEditNBT.this).selected.parent instanceof ButtonNBTMap;
                this.add((Widget)new SimpleButton((Panel)this, I18n.func_135052_a((String)"gui.rename", (Object[])new Object[0]), canRename ? GuiIcons.INFO : GuiIcons.INFO_GRAY, (gui, button) -> {
                    if (canRename) {
                        new GuiEditConfigValue(((GuiEditNBT)GuiEditNBT.this).selected.key, (ConfigValue)new ConfigString(((GuiEditNBT)GuiEditNBT.this).selected.key), (value, set) -> {
                            String s;
                            if (set && !(s = value.getString()).isEmpty()) {
                                ButtonNBTCollection parent = ((GuiEditNBT)GuiEditNBT.this).selected.parent;
                                String s0 = ((GuiEditNBT)GuiEditNBT.this).selected.key;
                                NBTBase nbt = parent.getTag(s0);
                                parent.setTag(s0, null);
                                parent.setTag(s, nbt);
                                parent.updateChildren(false);
                                GuiEditNBT.this.selected = parent.children.get(s);
                                GuiEditNBT.this.panelNbt.refreshWidgets();
                            }
                            this.getGui().openGui();
                        }).openGui();
                    }
                }));
                if (GuiEditNBT.this.selected instanceof ButtonNBTPrimitive) {
                    this.add((Widget)new SimpleButton((Panel)this, I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), GuiIcons.FEATHER, (widget, button) -> ((ButtonNBTPrimitive)GuiEditNBT.this.selected).edit()));
                }
                if (GuiEditNBT.this.selected.canCreateNew(10)) {
                    this.add((Widget)GuiEditNBT.this.newTag(this, "Compound", NBT_MAP, NBTTagCompound::new));
                }
                if (GuiEditNBT.this.selected.canCreateNew(9)) {
                    this.add((Widget)GuiEditNBT.this.newTag(this, "List", NBT_LIST, NBTTagList::new));
                }
                if (GuiEditNBT.this.selected.canCreateNew(8)) {
                    this.add((Widget)GuiEditNBT.this.newTag(this, "String", NBT_STRING, () -> new NBTTagString("")));
                }
                if (GuiEditNBT.this.selected.canCreateNew(1)) {
                    this.add((Widget)GuiEditNBT.this.newTag(this, "Byte", NBT_BYTE, () -> new NBTTagByte(0)));
                }
                if (GuiEditNBT.this.selected.canCreateNew(2)) {
                    this.add((Widget)GuiEditNBT.this.newTag(this, "Short", NBT_SHORT, () -> new NBTTagShort(0)));
                }
                if (GuiEditNBT.this.selected.canCreateNew(3)) {
                    this.add((Widget)GuiEditNBT.this.newTag(this, "Int", NBT_INT, () -> new NBTTagInt(0)));
                }
                if (GuiEditNBT.this.selected.canCreateNew(4)) {
                    this.add((Widget)GuiEditNBT.this.newTag(this, "Long", NBT_LONG, () -> new NBTTagLong(0L)));
                }
                if (GuiEditNBT.this.selected.canCreateNew(5)) {
                    this.add((Widget)GuiEditNBT.this.newTag(this, "Float", NBT_FLOAT, () -> new NBTTagFloat(0.0f)));
                }
                if (GuiEditNBT.this.selected.canCreateNew(6)) {
                    this.add((Widget)GuiEditNBT.this.newTag(this, "Double", NBT_DOUBLE, () -> new NBTTagDouble(0.0)));
                }
                if (GuiEditNBT.this.selected.canCreateNew(7)) {
                    this.add((Widget)GuiEditNBT.this.newTag(this, "Byte Array", NBT_BYTE_ARRAY, () -> new NBTTagByteArray(new byte[0])));
                }
                if (GuiEditNBT.this.selected.canCreateNew(11)) {
                    this.add((Widget)GuiEditNBT.this.newTag(this, "Int Array", NBT_INT_ARRAY, () -> new NBTTagIntArray(new int[0])));
                }
            }

            public void alignWidgets() {
                this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(2, 4, 2)));
            }
        };
        this.panelTopLeft.setPosAndSize(0, 2, 0, 16);
        this.panelTopRight = new Panel((Panel)this){

            public void addWidgets() {
                this.add((Widget)new SimpleButton((Panel)this, I18n.func_135052_a((String)"gui.copy", (Object[])new Object[0]), ItemIcon.getItemIcon((Item)Items.field_151121_aF), (widget, button) -> 3.setClipboardString((String)GuiEditNBT.this.selected.copy().toString())));
                this.add((Widget)new SimpleButton((Panel)this, I18n.func_135052_a((String)"gui.collapse_all", (Object[])new Object[0]), GuiIcons.REMOVE, (widget, button) -> {
                    for (Widget w : GuiEditNBT.this.panelNbt.widgets) {
                        if (!(w instanceof ButtonNBTCollection)) continue;
                        ((ButtonNBTCollection)w).setCollapsed(true);
                    }
                    GuiEditNBT.this.scroll.setValue(0);
                    GuiEditNBT.this.panelNbt.refreshWidgets();
                }));
                this.add((Widget)new SimpleButton((Panel)this, I18n.func_135052_a((String)"gui.expand_all", (Object[])new Object[0]), GuiIcons.ADD, (widget, button) -> {
                    for (Widget w : GuiEditNBT.this.panelNbt.widgets) {
                        if (!(w instanceof ButtonNBTCollection)) continue;
                        ((ButtonNBTCollection)w).setCollapsed(false);
                    }
                    GuiEditNBT.this.scroll.setValue(0);
                    GuiEditNBT.this.panelNbt.refreshWidgets();
                }));
                this.add((Widget)new SimpleButton((Panel)this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), GuiIcons.CANCEL, (widget, button) -> {
                    GuiEditNBT.this.shouldClose = 2;
                    widget.getGui().closeGui();
                }));
                this.add((Widget)new SimpleButton((Panel)this, I18n.func_135052_a((String)"gui.accept", (Object[])new Object[0]), GuiIcons.ACCEPT, (widget, button) -> {
                    GuiEditNBT.this.shouldClose = 1;
                    widget.getGui().closeGui();
                }));
            }

            public void alignWidgets() {
                this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(2, 4, 2)));
            }
        };
        this.panelNbt = new Panel((Panel)this){

            public void addWidgets() {
                this.add((Widget)GuiEditNBT.this.buttonNBTRoot);
                GuiEditNBT.this.buttonNBTRoot.addChildren();
            }

            public void alignWidgets() {
                GuiEditNBT.this.scroll.setMaxValue(this.align(WidgetLayout.VERTICAL) + 2);
            }
        };
        this.buttonNBTRoot = new ButtonNBTMap(this.panelNbt, null, this.info.func_74764_b("title") ? ITextComponent.Serializer.func_150699_a((String)this.info.func_74779_i("title")).func_150254_d() : "ROOT", nbt);
        this.buttonNBTRoot.updateChildren(true);
        this.buttonNBTRoot.setCollapsedTree(true);
        this.buttonNBTRoot.setCollapsed(false);
        this.selected = this.buttonNBTRoot;
        this.scroll = new PanelScrollBar((Panel)this, this.panelNbt);
    }

    public void addWidgets() {
        this.add((Widget)this.panelTopLeft);
        this.add((Widget)this.panelTopRight);
        this.add((Widget)this.panelNbt);
        this.add((Widget)this.scroll);
    }

    public void alignWidgets() {
        this.panelTopRight.setPosAndSize(this.width - this.panelTopRight.width, 2, 0, 16);
        this.panelTopRight.alignWidgets();
        this.panelNbt.setPosAndSize(0, 21, this.width - this.scroll.width, this.height - 20);
        this.panelNbt.alignWidgets();
        this.scroll.setPosAndSize(this.width - this.scroll.width, 20, 16, this.panelNbt.height);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void onClosed() {
        super.onClosed();
        if (this.shouldClose == 1) {
            if (NBTUtils.getSizeInBytes((NBTTagCompound)this.buttonNBTRoot.map, (boolean)false) >= 30000L) {
                FTBUtilities.LOGGER.error("NBT too large to send!");
            } else {
                new MessageEditNBTResponse(this.info, this.buttonNBTRoot.map).sendToServer();
            }
        }
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        GuiEditConfig.COLOR_BACKGROUND.draw(0, 0, w, 20);
    }

    public Theme getTheme() {
        return GuiEditConfig.THEME;
    }

    public boolean doesGuiPauseGame() {
        return true;
    }

    private /* synthetic */ void lambda$null$0(Supplier supplier, ConfigValue value, boolean set) {
        if (set && !value.getString().isEmpty()) {
            ((ButtonNBTCollection)this.selected).setTag(value.getString(), (NBTBase)supplier.get());
            this.selected.updateChildren(false);
            this.panelNbt.refreshWidgets();
        }
        this.openGui();
    }

    public class ButtonNBTIntArray
    extends ButtonNBTCollection {
        private IntArrayList list;

        public ButtonNBTIntArray(Panel panel, ButtonNBTCollection p, String key, NBTTagIntArray l) {
            super(panel, p, key, NBT_INT_ARRAY_OPEN, NBT_INT_ARRAY_CLOSED);
            this.list = new IntArrayList(l.func_150302_c());
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = GuiEditNBT.this.getFrom(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public NBTBase getTag(String k) {
            return new NBTTagInt(this.list.getInt(Integer.parseInt(k)));
        }

        @Override
        public void setTag(String k, @Nullable NBTBase base) {
            int id = Integer.parseInt(k);
            if (id == -1) {
                if (base != null) {
                    this.list.add(((NBTPrimitive)base).func_150287_d());
                }
            } else if (base != null) {
                this.list.set(id, ((NBTPrimitive)base).func_150287_d());
            } else {
                this.list.rem(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (NBTBase)new NBTTagIntArray(this.list.toIntArray()));
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return id == 3;
        }

        @Override
        public NBTTagCompound copy() {
            NBTTagCompound n = new NBTTagCompound();
            n.func_74782_a(this.key, (NBTBase)new NBTTagIntArray(this.list.toIntArray()));
            return n;
        }
    }

    public class ButtonNBTByteArray
    extends ButtonNBTCollection {
        private ByteArrayList list;

        public ButtonNBTByteArray(Panel panel, ButtonNBTCollection p, String key, NBTTagByteArray l) {
            super(panel, p, key, NBT_BYTE_ARRAY_OPEN, NBT_BYTE_ARRAY_CLOSED);
            this.list = new ByteArrayList(l.func_150292_c());
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = GuiEditNBT.this.getFrom(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public NBTBase getTag(String k) {
            return new NBTTagByte(this.list.getByte(Integer.parseInt(k)));
        }

        @Override
        public void setTag(String k, @Nullable NBTBase base) {
            int id = Integer.parseInt(k);
            if (id == -1) {
                if (base != null) {
                    this.list.add(((NBTPrimitive)base).func_150290_f());
                }
            } else if (base != null) {
                this.list.set(id, ((NBTPrimitive)base).func_150290_f());
            } else {
                this.list.rem((Object)id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (NBTBase)new NBTTagByteArray(this.list.toByteArray()));
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return id == 1;
        }

        @Override
        public NBTTagCompound copy() {
            NBTTagCompound n = new NBTTagCompound();
            n.func_74782_a(this.key, (NBTBase)new NBTTagByteArray(this.list.toByteArray()));
            return n;
        }
    }

    public class ButtonNBTList
    extends ButtonNBTCollection {
        private NBTTagList list;

        public ButtonNBTList(Panel panel, ButtonNBTCollection p, String key, NBTTagList l) {
            super(panel, p, key, NBT_LIST_OPEN, NBT_LIST_CLOSED);
            this.list = l;
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.func_74745_c(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = GuiEditNBT.this.getFrom(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public NBTBase getTag(String k) {
            return this.list.func_179238_g(Integer.parseInt(k));
        }

        @Override
        public void setTag(String k, @Nullable NBTBase base) {
            int id = Integer.parseInt(k);
            if (id == -1) {
                if (base != null) {
                    this.list.func_74742_a(base);
                }
            } else if (base != null) {
                this.list.func_150304_a(id, base);
            } else {
                this.list.func_74744_a(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (NBTBase)this.list);
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return this.list.func_82582_d() || this.list.func_150303_d() == id;
        }

        @Override
        public NBTTagCompound copy() {
            NBTTagCompound n = new NBTTagCompound();
            n.func_74782_a(this.key, (NBTBase)this.list);
            return n;
        }
    }

    public class ButtonNBTMap
    extends ButtonNBTCollection {
        private NBTTagCompound map;
        private Icon hoverIcon;

        public ButtonNBTMap(@Nullable Panel panel, ButtonNBTCollection b, String key, NBTTagCompound m) {
            super(panel, b, key, NBT_MAP_OPEN, NBT_MAP_CLOSED);
            this.hoverIcon = Icon.EMPTY;
            this.map = m;
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            ArrayList list = new ArrayList(this.map.func_150296_c());
            list.sort(StringUtils.IGNORE_CASE_COMPARATOR);
            for (String s : list) {
                ButtonNBT nbt = GuiEditNBT.this.getFrom(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
            this.updateHoverIcon();
            if (first && !this.hoverIcon.isEmpty()) {
                this.setCollapsed(true);
            }
        }

        private void updateHoverIcon() {
            ItemEntryWithCount entry = new ItemEntryWithCount((NBTBase)this.map.func_74737_b());
            this.hoverIcon = !entry.isEmpty() ? ItemIcon.getItemIcon((ItemStack)entry.getStack(false)) : Icon.EMPTY;
            this.setWidth(12 + GuiEditNBT.this.getTheme().getStringWidth(this.getTitle()) + (this.hoverIcon.isEmpty() ? 0 : 10));
        }

        @Override
        public void addMouseOverText(List<String> list) {
            NBTTagList infoList;
            if (this == GuiEditNBT.this.buttonNBTRoot && (infoList = GuiEditNBT.this.info.func_150295_c("text", 8)).func_74745_c() > 0) {
                list.add(I18n.func_135052_a((String)"gui.info", (Object[])new Object[0]) + ":");
                for (int i = 0; i < infoList.func_74745_c(); ++i) {
                    ITextComponent component = ITextComponent.Serializer.func_150699_a((String)infoList.func_150307_f(i));
                    if (component == null) continue;
                    list.add(component.func_150254_d());
                }
            }
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            super.draw(theme, x, y, w, h);
            if (!this.hoverIcon.isEmpty()) {
                this.hoverIcon.draw(x + 12 + theme.getStringWidth(this.getTitle()), y + 1, 8, 8);
            }
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return new WrappedIngredient(this.hoverIcon.getIngredient()).tooltip();
        }

        @Override
        public NBTBase getTag(String k) {
            return this.map.func_74781_a(k);
        }

        @Override
        public void setTag(String k, @Nullable NBTBase base) {
            if (base != null) {
                this.map.func_74782_a(k, base);
            } else {
                this.map.func_82580_o(k);
            }
            this.updateHoverIcon();
            if (this.parent != null) {
                this.parent.setTag(this.key, (NBTBase)this.map);
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return true;
        }

        @Override
        public NBTTagCompound copy() {
            NBTTagCompound nbt = this.map.func_74737_b();
            if (this == GuiEditNBT.this.buttonNBTRoot) {
                NBTTagList infoList1 = new NBTTagList();
                NBTTagList infoList0 = GuiEditNBT.this.info.func_150295_c("text", 8);
                if (infoList0.func_74745_c() > 0) {
                    for (int i = 0; i < infoList0.func_74745_c(); ++i) {
                        ITextComponent component = ITextComponent.Serializer.func_150699_a((String)infoList0.func_150307_f(i));
                        if (component == null) continue;
                        infoList1.func_74742_a((NBTBase)new NBTTagString(component.func_150260_c()));
                    }
                    nbt.func_74782_a("_", (NBTBase)infoList1);
                }
            }
            return nbt;
        }
    }

    public abstract class ButtonNBTCollection
    extends ButtonNBT {
        public boolean collapsed;
        public final Map<String, ButtonNBT> children;
        public final Icon iconOpen;
        public final Icon iconClosed;

        public ButtonNBTCollection(@Nullable Panel panel, ButtonNBTCollection b, String key, Icon open, Icon closed) {
            super(panel, b, key);
            this.iconOpen = open;
            this.iconClosed = closed;
            this.setCollapsed(false);
            this.setWidth(this.width + 2 + GuiEditNBT.this.getTheme().getStringWidth(key));
            this.children = new LinkedHashMap<String, ButtonNBT>();
        }

        @Override
        public void addChildren() {
            if (!this.collapsed) {
                for (ButtonNBT button : this.children.values()) {
                    GuiEditNBT.this.panelNbt.add((Widget)button);
                    button.addChildren();
                }
            }
        }

        public void onClicked(MouseButton button) {
            if (this.getMouseX() <= this.getX() + this.height) {
                this.setCollapsed(!this.collapsed);
                GuiEditNBT.this.panelNbt.refreshWidgets();
            } else {
                GuiEditNBT.this.selected = this;
                GuiEditNBT.this.panelTopLeft.refreshWidgets();
            }
        }

        public void setCollapsed(boolean c) {
            this.collapsed = c;
            this.setIcon(this.collapsed ? this.iconClosed : this.iconOpen);
        }

        public void setCollapsedTree(boolean c) {
            this.setCollapsed(c);
            for (ButtonNBT button : this.children.values()) {
                if (!(button instanceof ButtonNBTCollection)) continue;
                ((ButtonNBTCollection)button).setCollapsedTree(c);
            }
        }

        public abstract NBTBase getTag(String var1);

        public abstract void setTag(String var1, @Nullable NBTBase var2);
    }

    public class ButtonNBTPrimitive
    extends ButtonNBT
    implements IConfigValueEditCallback {
        private NBTBase nbt;

        public ButtonNBTPrimitive(Panel panel, ButtonNBTCollection b, String k, NBTBase n) {
            super(panel, b, k);
            this.nbt = n;
            switch (this.nbt.func_74732_a()) {
                case 1: {
                    this.setIcon(NBT_BYTE);
                    break;
                }
                case 2: {
                    this.setIcon(NBT_SHORT);
                    break;
                }
                case 3: {
                    this.setIcon(NBT_INT);
                    break;
                }
                case 4: {
                    this.setIcon(NBT_LONG);
                    break;
                }
                case 5: {
                    this.setIcon(NBT_FLOAT);
                    break;
                }
                case 6: 
                case 99: {
                    this.setIcon(NBT_DOUBLE);
                    break;
                }
                case 8: {
                    this.setIcon(NBT_STRING);
                }
            }
            this.parent.setTag(this.key, this.nbt);
            this.updateTitle();
        }

        public void updateTitle() {
            Object title = "";
            switch (this.nbt.func_74732_a()) {
                case 1: 
                case 2: 
                case 3: {
                    title = ((NBTPrimitive)this.nbt).func_150287_d();
                    break;
                }
                case 4: {
                    title = ((NBTPrimitive)this.nbt).func_150291_c();
                    break;
                }
                case 5: 
                case 6: 
                case 99: {
                    title = ((NBTPrimitive)this.nbt).func_150286_g();
                    break;
                }
                case 8: {
                    title = ((NBTTagString)this.nbt).func_150285_a_();
                }
            }
            this.setTitle(this.key + ": " + title);
            this.setWidth(12 + GuiEditNBT.this.getTheme().getStringWidth(this.key + ": " + title));
        }

        public void onClicked(MouseButton button) {
            GuiEditNBT.this.selected = this;
            GuiEditNBT.this.panelTopLeft.refreshWidgets();
            if (button.isRight()) {
                this.edit();
            }
        }

        public void edit() {
            switch (this.nbt.func_74732_a()) {
                case 1: 
                case 2: 
                case 3: {
                    new GuiEditConfigValue(this.key, (ConfigValue)new ConfigInt(((NBTPrimitive)this.nbt).func_150287_d()), (IConfigValueEditCallback)this).openGui();
                    break;
                }
                case 4: {
                    new GuiEditConfigValue(this.key, (ConfigValue)new ConfigString(Long.toString(((NBTPrimitive)this.nbt).func_150291_c())), (IConfigValueEditCallback)this).openGui();
                    break;
                }
                case 5: 
                case 6: 
                case 99: {
                    new GuiEditConfigValue(this.key, (ConfigValue)new ConfigDouble(((NBTPrimitive)this.nbt).func_150286_g()), (IConfigValueEditCallback)this).openGui();
                    break;
                }
                case 8: {
                    new GuiEditConfigValue(this.key, (ConfigValue)new ConfigString(((NBTTagString)this.nbt).func_150285_a_()), (IConfigValueEditCallback)this).openGui();
                }
            }
        }

        public void onCallback(ConfigValue value, boolean set) {
            if (set) {
                switch (this.nbt.func_74732_a()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.nbt = new NBTTagInt(value.getInt());
                        break;
                    }
                    case 4: {
                        this.nbt = new NBTTagLong(Long.parseLong(value.getString()));
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 99: {
                        this.nbt = new NBTTagDouble(value.getDouble());
                        break;
                    }
                    case 8: {
                        this.nbt = new NBTTagString(value.getString());
                    }
                }
                this.parent.setTag(this.key, this.nbt);
                this.updateTitle();
            }
            GuiEditNBT.this.openGui();
        }

        @Override
        public NBTTagCompound copy() {
            NBTTagCompound n = new NBTTagCompound();
            n.func_74782_a(this.key, this.nbt);
            return n;
        }
    }

    public abstract class ButtonNBT
    extends Button {
        public final ButtonNBTCollection parent;
        public String key;

        public ButtonNBT(@Nullable Panel panel, ButtonNBTCollection b, String k) {
            super(panel);
            this.setPosAndSize(b == null ? 0 : b.posX + 10, 0, 10, 10);
            this.parent = b;
            this.key = k;
            this.setTitle(this.key);
        }

        public abstract NBTTagCompound copy();

        public void updateChildren(boolean first) {
        }

        public void addChildren() {
        }

        public boolean canCreateNew(int id) {
            return false;
        }

        public void addMouseOverText(List<String> list) {
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            if (GuiEditNBT.this.selected == this) {
                Color4I.WHITE.withAlpha(33).draw(x, y, w, h);
            }
            IconWithOutline.BUTTON_ROUND_GRAY.draw(x + 1, y + 1, 8, 8);
            this.drawIcon(theme, x + 1, y + 1, 8, 8);
            theme.drawString(this.getTitle(), x + 11, y + 1);
        }
    }
}

