/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.gui.ranks;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.icon.PlayerHeadIcon;
import com.feed_the_beast.ftblib.lib.util.FinalIDObject;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbutilities.gui.ranks.GuiEditRank;
import com.feed_the_beast.ftbutilities.gui.ranks.GuiPlayerRanks;
import com.feed_the_beast.ftbutilities.gui.ranks.RankInst;
import com.feed_the_beast.ftbutilities.ranks.Rank;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;

public class GuiRanks
extends GuiButtonListBase {
    public final Map<String, Tag> tags = new LinkedHashMap<String, Tag>();
    public final Map<String, RankGuiInst> ranks = new LinkedHashMap<String, RankGuiInst>();
    public final Map<String, String> playerRanks;

    public GuiRanks(Collection<RankInst> r, Collection<String> t, Map<String, String> p) {
        ArrayList<Tag> tagsList = new ArrayList<Tag>();
        for (String string : t) {
            tagsList.add(new Tag(string));
        }
        tagsList.sort(null);
        for (Tag tag : tagsList) {
            this.tags.put(tag.getId(), tag);
        }
        for (RankInst rankInst : r) {
            RankGuiInst inst1 = new RankGuiInst(rankInst.getId());
            for (String tag : rankInst.tags) {
                Tag tag1 = this.tags.get(tag);
                if (tag1 == null) continue;
                inst1.tags.add(tag1);
            }
            inst1.permissions.addAll(rankInst.permissions);
            this.ranks.put(inst1.getId(), inst1);
        }
        for (RankInst rankInst : r) {
            this.ranks.get((Object)rankInst.getId()).parent = this.ranks.get(rankInst.parent);
        }
        this.playerRanks = p;
    }

    public void addButtons(Panel panel) {
        panel.add((Widget)new SimpleTextButton(panel, I18n.func_135052_a((String)"admin_panel.ftbutilities.ranks.player_ranks", (Object[])new Object[0]), new PlayerHeadIcon(null).withBorder(4)){

            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                new GuiPlayerRanks(GuiRanks.this).openGui();
            }
        });
        panel.add((Widget)new SimpleTextButton(panel, I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]), GuiIcons.ADD){

            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
            }
        });
        for (final RankGuiInst inst : this.ranks.values()) {
            panel.add((Widget)new SimpleTextButton(panel, StringUtils.firstUppercase((String)inst.getId()), GuiIcons.SETTINGS){

                public void onClicked(MouseButton button) {
                    GuiHelper.playClickSound();
                    new GuiEditRank(GuiRanks.this, inst).openGui();
                }
            });
        }
    }

    public static class RankGuiInst
    extends FinalIDObject {
        public RankGuiInst parent = null;
        public final HashSet<Tag> tags = new HashSet();
        public final List<Rank.Entry> permissions = new ArrayList<Rank.Entry>();

        public RankGuiInst(String id) {
            super(id);
        }
    }

    public static class Tag
    extends FinalIDObject
    implements Comparable<Tag> {
        public final String displayName = I18n.func_188566_a((String)("ftbutilities.ranks.tags." + this.getId())) ? I18n.func_135052_a((String)("ftbutilities.ranks.tags." + this.getId()), (Object[])new Object[0]) : this.getId();

        private Tag(String tag) {
            super(tag);
        }

        @Override
        public int compareTo(Tag o) {
            return this.displayName.compareTo(o.displayName);
        }
    }
}

