/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.integration.aurora;

import com.feed_the_beast.ftbutilities.ranks.CommandOverride;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import dev.latvian.mods.aurora.page.HTTPWebPage;
import dev.latvian.mods.aurora.tag.Tag;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;

public class CommandListPage
extends HTTPWebPage {
    private final MinecraftServer server;

    public CommandListPage(MinecraftServer s) {
        this.server = s;
    }

    public String getTitle() {
        return "FTB Utilities";
    }

    public String getDescription() {
        return "Command List";
    }

    public String getIcon() {
        return "https://i.imgur.com/aIuCGYZ.png";
    }

    public void head(Tag head) {
        super.head(head);
        ArrayList<String> style = new ArrayList<String>();
        style.add("p{margin:0;}");
        head.paired("style", String.join((CharSequence)"\r\n", style));
    }

    private String fixHTML(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public void body(Tag body) {
        Tag nodeTable = body.table();
        Tag firstRow = nodeTable.tr();
        firstRow.th().text((Object)"Available command nodes");
        firstRow.th().text((Object)"Usage");
        for (CommandOverride c : Ranks.INSTANCE.commands.values()) {
            Tag row = nodeTable.tr();
            row.td().paired("code", c.node.toString());
            row.td().text((Object)this.fixHTML(c.usage.func_150260_c()).replace(" OR ", "<br>"));
        }
    }
}

