/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.integration.kubejs;

import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.data.ClaimedChunk;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesPlayerData;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesTeamData;
import com.feed_the_beast.ftbutilities.ranks.Rank;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import dev.latvian.kubejs.player.PlayerDataJS;
import java.util.Collections;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class KubeJSFTBUtilitiesPlayerData {
    private final PlayerDataJS playerData;
    private FTBUtilitiesPlayerData cached;

    public KubeJSFTBUtilitiesPlayerData(PlayerDataJS d) {
        this.playerData = d;
    }

    public FTBUtilitiesPlayerData getWrappedPlayerData() {
        if (this.cached == null) {
            this.cached = FTBUtilitiesPlayerData.get(Universe.get().getPlayer((ICommandSender)this.playerData.getPlayerEntity()));
        }
        return this.cached;
    }

    public String getRank() {
        if (!Ranks.isActive()) {
            return "";
        }
        EntityPlayer player = this.playerData.getPlayerEntity();
        if (!(player instanceof EntityPlayerMP)) {
            return "";
        }
        Rank rank = Ranks.INSTANCE.getRank(player.func_184102_h(), player.func_146103_bH(), null);
        return rank.isNone() ? "" : rank.getId();
    }

    public void setRank(String rank) {
        if (Ranks.isActive()) {
            Ranks.INSTANCE.setRank(this.playerData.getId(), Ranks.INSTANCE.getRank(rank));
        }
    }

    public Set<ClaimedChunk> getClaimedChunks() {
        if (ClaimedChunks.isActive()) {
            return ClaimedChunks.instance.getTeamChunks(this.getWrappedPlayerData().player.team, OptionalInt.empty());
        }
        return Collections.emptySet();
    }

    public boolean getAfk() {
        return this.getWrappedPlayerData().afkTime >= FTBUtilitiesConfig.afk.getNotificationTimer();
    }

    public boolean getEnablePVP() {
        return this.getWrappedPlayerData().enablePVP();
    }

    public String getNickname() {
        return this.getWrappedPlayerData().getNickname();
    }

    public void setNickname(String nickname) {
        this.getWrappedPlayerData().setNickname(nickname);
    }

    public int getMaxClaimChunks() {
        return FTBUtilitiesTeamData.get(this.getWrappedPlayerData().player.team).getMaxClaimChunks();
    }

    public int getMaxChunkloaderChunks() {
        return FTBUtilitiesTeamData.get(this.getWrappedPlayerData().player.team).getMaxChunkloaderChunks();
    }
}

