/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.splashanimation;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.SplashProgress;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class SplashAnimationRenderer {
    private static boolean animationSolid = false;
    private static boolean animationScaleUp = false;
    private static boolean animationScaleDown = false;
    private static boolean animationScaleFilter = false;
    private static int backgroundColor = 0;
    private static float frameDelay = 0.0f;
    private static float fadeOutTime = 0.0f;
    private static long startTime = 0L;
    private static int animTexture;
    private static int animTexWidth;
    private static int animTexHeight;
    private static int stage;
    private static int width;
    private static int height;
    private static ImageProvider provider;
    private static Thread providerThread;
    private static int frameCount;
    private static int uploadedFrame;

    public static void run() {
        switch (stage) {
            case 0: {
                SplashAnimationRenderer.init();
                if (stage == 2) break;
                stage = 1;
            }
            case 1: {
                SplashAnimationRenderer.render();
                break;
            }
            case 2: {
                SplashAnimationRenderer.finish();
                break;
            }
        }
    }

    private static void init() {
        File confDir = new File("config");
        Configuration config = new Configuration(new File(confDir, "splashanimation.cfg"));
        animationSolid = config.getBoolean("areFramesSolid", "animation", true, "Are the animation frames solid?");
        animationScaleUp = config.getBoolean("enableScalingUp", "animation", false, "Should the animation scale up to fill the screen?");
        animationScaleDown = config.getBoolean("enableScalingDown", "animation", true, "Should the animation scale down to fill the screen?");
        animationScaleFilter = config.getBoolean("enableScalingFilter", "animation", true, "Should the animation, if scaled, use a bilinear filter?");
        backgroundColor = Integer.parseInt(config.getString("backgroundColor", "animation", "000000", "The background color used during the animation."), 16);
        frameDelay = config.getFloat("frameDelay", "animation", 0.03f, 0.005f, 1.0f, "The delay for each frame of animation, in seconds.");
        fadeOutTime = config.getFloat("fadeOutTime", "animation", 1.0f, 0.0f, 5.0f, "The fade out time after the final frame of animation.");
        String frameStr = config.getString("frameFileDirectory", "animation", "animation", "The directory containing the animation frames, which should be of the filename format [number].[extension].");
        if (config.hasChanged()) {
            config.save();
        }
        File imgDir = new File(frameStr);
        TreeMap<Integer, File> files = new TreeMap<Integer, File>();
        if (imgDir.exists() && imgDir.isDirectory()) {
            for (File imgFile : imgDir.listFiles()) {
                String s = imgFile.getName().split("\\.")[0];
                try {
                    Integer i = Integer.valueOf(s);
                    if (i < 0) continue;
                    files.put(i, imgFile);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        ArrayList<File> imageFiles = new ArrayList<File>();
        BufferedImage image = null;
        for (Map.Entry entry : files.entrySet()) {
            imageFiles.add((File)entry.getValue());
            if (width >= 0 && height >= 0) continue;
            try {
                image = ImageIO.read((File)entry.getValue());
                width = image.getWidth();
                height = image.getHeight();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (imageFiles.isEmpty() || image == null || width < 0 || height < 0) {
            System.err.println("Found no images!");
            stage = 2;
            return;
        }
        frameCount = imageFiles.size();
        provider = new ImageProvider(imageFiles, image);
        providerThread = new Thread(provider);
        providerThread.start();
        animTexWidth = MathHelper.func_151236_b((int)width);
        animTexHeight = MathHelper.func_151236_b((int)height);
        int maxSize = SplashProgress.getMaxTextureSize();
        if (animTexWidth > maxSize || animTexHeight > maxSize) {
            System.err.println("Could not fit animation: " + maxSize + " too small");
            stage = 2;
            return;
        }
        GL11.glEnable((int)3553);
        animTexture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)animTexture);
        if (animationScaleFilter) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)animTexWidth, (int)animTexHeight, (int)0, (int)32993, (int)33639, (IntBuffer)null);
        GL11.glDisable((int)3553);
        startTime = System.currentTimeMillis();
    }

    private static void bindFrame(int i) {
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)animTexture);
        if (i != uploadedFrame) {
            BufferedImage img = provider.getImage(i);
            if (img.getWidth() > animTexWidth || img.getHeight() > animTexHeight) {
                throw new RuntimeException("Splash frames not the same size!");
            }
            int[] t = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
            IntBuffer buf = BufferUtils.createIntBuffer((int)t.length);
            buf.put(t);
            buf.position(0);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)img.getWidth(), (int)img.getHeight(), (int)32993, (int)33639, (IntBuffer)buf);
            uploadedFrame = i;
        }
    }

    private static void glColor(int v) {
        GL11.glColor4f((float)((float)(v >> 16 & 0xFF) / 255.0f), (float)((float)(v >> 8 & 0xFF) / 255.0f), (float)((float)(v & 0xFF) / 255.0f), (float)((float)(v >> 24 & 0xFF) / 255.0f));
    }

    private static void glColor(int v, float a) {
        GL11.glColor4f((float)((float)(v >> 16 & 0xFF) / 255.0f), (float)((float)(v >> 8 & 0xFF) / 255.0f), (float)((float)(v & 0xFF) / 255.0f), (float)a);
    }

    private static void render() {
        float scalingFactor;
        int finalElapsedMs = (int)((float)frameCount * (frameDelay * 1000.0f));
        int elapsedMs = (int)(System.currentTimeMillis() - startTime);
        int i = (int)((float)elapsedMs / 1000.0f / frameDelay);
        float alpha = 1.0f;
        if (elapsedMs >= finalElapsedMs && (alpha = 1.0f - (float)(elapsedMs - finalElapsedMs) / (fadeOutTime * 1000.0f)) < 0.0f) {
            stage = 2;
            return;
        }
        float w = Display.getWidth();
        float h = Display.getHeight();
        float iw = width;
        float ih = height;
        GL11.glViewport((int)0, (int)0, (int)((int)w), (int)((int)h));
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)(-w / 2.0f), (double)(w / 2.0f), (double)(h / 2.0f), (double)(-h / 2.0f), (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        float maxU = iw / (float)animTexWidth;
        float maxV = ih / (float)animTexHeight;
        float imgRatio = iw / ih;
        float dispRatio = w / h;
        float f = scalingFactor = dispRatio > imgRatio ? h / ih : w / iw;
        if (animationScaleUp && scalingFactor > 1.0f || animationScaleDown && scalingFactor < 1.0f) {
            iw *= scalingFactor;
            ih *= scalingFactor;
        }
        GL11.glDisable((int)3553);
        SplashAnimationRenderer.glColor(backgroundColor, alpha);
        GL11.glBegin((int)7);
        if (animationSolid && alpha < 1.0f) {
            GL11.glVertex2f((float)(-w / 2.0f), (float)(-h / 2.0f));
            GL11.glVertex2f((float)(-w / 2.0f), (float)(-ih / 2.0f));
            GL11.glVertex2f((float)(w / 2.0f), (float)(-ih / 2.0f));
            GL11.glVertex2f((float)(w / 2.0f), (float)(-h / 2.0f));
            GL11.glVertex2f((float)(-w / 2.0f), (float)(ih / 2.0f));
            GL11.glVertex2f((float)(-w / 2.0f), (float)(h / 2.0f));
            GL11.glVertex2f((float)(w / 2.0f), (float)(h / 2.0f));
            GL11.glVertex2f((float)(w / 2.0f), (float)(ih / 2.0f));
            GL11.glVertex2f((float)(-w / 2.0f), (float)(-ih / 2.0f));
            GL11.glVertex2f((float)(-w / 2.0f), (float)(ih / 2.0f));
            GL11.glVertex2f((float)(-iw / 2.0f), (float)(ih / 2.0f));
            GL11.glVertex2f((float)(-iw / 2.0f), (float)(-ih / 2.0f));
            GL11.glVertex2f((float)(iw / 2.0f), (float)(-ih / 2.0f));
            GL11.glVertex2f((float)(iw / 2.0f), (float)(ih / 2.0f));
            GL11.glVertex2f((float)(w / 2.0f), (float)(ih / 2.0f));
            GL11.glVertex2f((float)(w / 2.0f), (float)(-ih / 2.0f));
        } else {
            GL11.glVertex2f((float)(-w / 2.0f), (float)(-h / 2.0f));
            GL11.glVertex2f((float)(-w / 2.0f), (float)(h / 2.0f));
            GL11.glVertex2f((float)(w / 2.0f), (float)(h / 2.0f));
            GL11.glVertex2f((float)(w / 2.0f), (float)(-h / 2.0f));
        }
        GL11.glEnd();
        SplashAnimationRenderer.bindFrame(i);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)(-iw / 2.0f), (float)(-ih / 2.0f));
        GL11.glTexCoord2f((float)0.0f, (float)maxV);
        GL11.glVertex2f((float)(-iw / 2.0f), (float)(ih / 2.0f));
        GL11.glTexCoord2f((float)maxU, (float)maxV);
        GL11.glVertex2f((float)(iw / 2.0f), (float)(ih / 2.0f));
        GL11.glTexCoord2f((float)maxU, (float)0.0f);
        GL11.glVertex2f((float)(iw / 2.0f), (float)(-ih / 2.0f));
        GL11.glEnd();
        GL11.glDisable((int)3553);
    }

    public static void finish() {
        if (stage <= 2) {
            GL11.glDeleteTextures((int)animTexture);
            if (provider != null) {
                provider.stop();
            }
            provider = null;
            providerThread = null;
            stage = 3;
        }
    }

    static {
        stage = 0;
        width = -1;
        height = -1;
        uploadedFrame = -1;
    }

    public static class ImageProvider
    implements Runnable {
        private final LinkedList<File> fileList = new LinkedList();
        private final LinkedList<BufferedImage> imageList = new LinkedList();
        private final int bufferSize;
        private int lastImage = 0;
        private boolean run = true;

        public ImageProvider(Collection<File> files, BufferedImage ... initialImages) {
            this.fileList.addAll(files);
            this.imageList.addAll(Arrays.asList(initialImages));
            this.lastImage = this.imageList.size();
            for (int i = 0; i < this.lastImage; ++i) {
                this.fileList.remove();
            }
            this.bufferSize = Math.max(5, (int)Math.ceil(1.0f / frameDelay));
        }

        public BufferedImage getImage(int pos) {
            while (this.lastImage < pos) {
                if (this.imageList.size() == 1) {
                    return this.imageList.peekFirst();
                }
                if (this.imageList.isEmpty()) {
                    return new BufferedImage(1, 1, 2);
                }
                this.imageList.remove();
                ++this.lastImage;
            }
            if (this.imageList.isEmpty()) {
                return new BufferedImage(1, 1, 2);
            }
            return this.imageList.peekFirst();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (this.run) {
                try {
                    while (this.imageList.size() < this.bufferSize && !this.fileList.isEmpty()) {
                        File f = this.fileList.remove();
                        try {
                            BufferedImage img = ImageIO.read(f);
                            LinkedList<BufferedImage> linkedList = this.imageList;
                            synchronized (linkedList) {
                                this.imageList.add(img);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Thread.sleep(Math.round(frameDelay * 1000.0f));
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }

        public void stop() {
            this.run = false;
        }
    }
}

