/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.XUBlockTESR;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.BoxSingleQuad;
import com.rwtema.extrautils2.backend.model.Textures;
import java.util.function.DoubleBinaryOperator;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;

public class BlockKlein
extends XUBlockTESR {
    static final double STEM_WIDTH = 0.1;
    static final double STEM_HEIGHT = 0.7;
    static final double LOOP_RADIUS = 0.30000000000000004;
    static final double OFFSET = 0.35;
    static final double OFFSET2 = 0.65;
    static final double OFFSET3 = 0.1;

    public static double getStemRadius(double t) {
        if (t < 0.0) {
            t = (t + 10.0) % 1.0;
        } else if (t > 1.0) {
            t %= 1.0;
        }
        if (t < 0.35) {
            return BlockKlein.getBulbWidth(t / 0.35);
        }
        if (t < 0.44999999999999996) {
            double v = (t - 0.35) / 0.1;
            v = (1.0 + Math.cos(v * Math.PI)) / 2.0;
            return (1.0 - v) * 0.1 + v * BlockKlein.getBulbWidth(1.0);
        }
        if (t > 0.9 && t < 1.0) {
            double v = (t - 0.9) / 0.1;
            if (v > 1.0) {
                v = 1.0;
            }
            v = Math.sqrt(1.0 - v * v);
            return (1.0 - v) * 0.1 + v * BlockKlein.getBulbWidth(0.0);
        }
        return 0.1;
    }

    public static double getBulbWidth(double t) {
        double a = 0.1 + 0.2 * BlockKlein.circle(-1.0 + t * 3.0);
        double v2 = 0.8 * (1.0 - t) + t * 0.1;
        return t * v2 + (1.0 - t) * a;
    }

    public static Vec3d getStemNormal(double t) {
        double y;
        double x;
        boolean isReturning;
        if (t < 0.0) {
            t = (t + 10.0) % 1.0;
        }
        if (t > 1.0) {
            isReturning = true;
            t %= 1.0;
        } else {
            isReturning = false;
        }
        if (t < 0.35) {
            x = -1.0;
            y = 0.0;
        } else if (t < 0.65) {
            double k = (t - 0.35) / 0.30000000000000004 * Math.PI;
            x = -Math.cos(k);
            y = Math.sin(k);
        } else {
            double v;
            double k = (t - 0.65) / 0.35;
            y = -Math.sin(k * Math.PI);
            x = v = 1.0 / Math.sqrt(1.0 + y * y);
            y *= v;
        }
        if (isReturning) {
            x *= -1.0;
            y *= -1.0;
        }
        return new Vec3d(x, y, 0.0);
    }

    public static Vec3d getStemPos(double t) {
        double y;
        double x;
        if (t < 0.0) {
            t = (t + 10.0) % 1.0;
        } else if (t > 1.0) {
            t %= 1.0;
        }
        if (t < 0.35) {
            x = 0.0;
            y = t / 0.35 * 0.7;
        } else if (t < 0.65) {
            double k = (t - 0.35) / 0.30000000000000004 * Math.PI;
            x = 0.30000000000000004 - 0.30000000000000004 * Math.cos(k);
            y = 0.7 + 0.30000000000000004 * Math.sin(k);
        } else {
            double k = (t - 0.65) / 0.35;
            x = 0.30000000000000004 + 0.30000000000000004 * Math.cos(k * Math.PI);
            y = 0.7 * (1.0 - k);
        }
        return new Vec3d(0.34455 + x, -0.05 + y, 0.5);
    }

    public static double circle(double t) {
        if (t < -1.0) {
            return 0.0;
        }
        if (t > 1.0) {
            return 0.0;
        }
        return Math.sqrt(1.0 - t * t);
    }

    public static Vec3d apply(Vec3d a, Vec3d b, DoubleBinaryOperator f) {
        return new Vec3d(f.applyAsDouble(a.field_72450_a, b.field_72450_a), f.applyAsDouble(a.field_72448_b, b.field_72448_b), f.applyAsDouble(a.field_72449_c, b.field_72449_c));
    }

    @Override
    public void registerTextures() {
        Textures.register("klein_lighting");
    }

    @Override
    public BoxModel getWorldModel(@Nullable ItemStack stack, IBlockState state, float timer) {
        BoxModel model = new BoxModel();
        model.addBoxI(0, 0, 0, 16, 16, 16);
        return model;
    }

    @Override
    public BoxModel getRenderModel(@Nullable ItemStack stack, IBlockState state, float timer) {
        BoxModel model = new BoxModel();
        double time = timer / 30.0f % 4.0f;
        double offset = 0.05;
        int angle_n = 8;
        int height_n = 10;
        double[] ca = new double[8];
        double[] sa = new double[8];
        for (int i = 0; i < 8; ++i) {
            double t = (double)i * Math.PI * 2.0 / 8.0;
            ca[i] = Math.cos(t);
            sa[i] = Math.sin(t);
        }
        double r = 0.95;
        for (int z = -1; z <= 1; z += 2) {
            int i = 0;
            while (z == 1 ? i < 10 : i > -10) {
                double tA = time + 0.05 * (double)i;
                double tB = time + 0.05 * (double)(i + 1);
                Vec3d stemPosA = BlockKlein.getStemPos(tA).func_178786_a(0.5, 0.5, 0.5).func_186678_a(0.95).func_72441_c(0.5, 0.5, 0.5);
                Vec3d stemPosB = BlockKlein.getStemPos(tB).func_178786_a(0.5, 0.5, 0.5).func_186678_a(0.95).func_72441_c(0.5, 0.5, 0.5);
                double radA = BlockKlein.getStemRadius(tA) * 0.95;
                double radB = BlockKlein.getStemRadius(tB) * 0.95;
                Vec3d normA = BlockKlein.getStemNormal(tA);
                Vec3d normB = BlockKlein.getStemNormal(tB);
                for (int j = 0; j < 8; ++j) {
                    int j2 = (j + 1) % 8;
                    float u0 = (float)j / 8.0f;
                    float u1 = (float)(j + 1) / 8.0f;
                    float v0 = (1.0f + (float)i / 10.0f) / 2.0f;
                    float v1 = (1.0f + (float)(i + 1) / 10.0f) / 2.0f;
                    model.add(new BoxSingleQuad(stemPosA.func_178787_e(normA.func_186678_a(radA * ca[j])).func_72441_c(0.0, 0.0, radA * sa[j]), u0, v0, stemPosB.func_178787_e(normB.func_186678_a(radB * ca[j])).func_72441_c(0.0, 0.0, radB * sa[j]), u0, v1, stemPosB.func_178787_e(normB.func_186678_a(radB * ca[j2])).func_72441_c(0.0, 0.0, radB * sa[j2]), u1, v1, stemPosA.func_178787_e(normA.func_186678_a(radA * ca[j2])).func_72441_c(0.0, 0.0, radA * sa[j2]), u1, v0).setDoubleSided(false).setTexture("klein_lighting"));
                }
                i += z;
            }
        }
        return model;
    }

    static interface dubFunc {
        public double apply(double var1, double var3);
    }
}

