/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.backend.ClientRunnable;
import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.items.ItemLawSword;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketServerToClient;
import com.rwtema.extrautils2.utils.datastructures.WeakLinkedSet;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCompoundBow
extends ItemBow
implements IXUItem {
    public static final float DRAW_TIME = 20.0f;
    private static WeakLinkedSet<EntityArrow> blue_arrows = new WeakLinkedSet();
    String[] tex = new String[]{"compound_bow", "compound_bow_pull_0", "compound_bow_pull_1", "compound_bow_pull_2", "compound_bow_pull_charged"};

    public ItemCompoundBow() {
        MinecraftForge.EVENT_BUS.register((Object)new ItemLawSword.OPAnvilHandler((Item)this));
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    private static float getArrowVelocityCustom(int charge) {
        float f = (float)charge / 20.0f;
        if (f < 0.0f) {
            return 0.0f;
        }
        if ((f = (f + (float)Math.sqrt(f) * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void tickClient(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        Iterator<EntityArrow> iterator = blue_arrows.iterator();
        while (iterator.hasNext()) {
            EntityArrow blue_arrow = iterator.next();
            if (blue_arrow.field_70128_L || blue_arrow.field_70254_i) {
                iterator.remove();
                continue;
            }
            for (int i = 0; i < 5; ++i) {
                for (int k = 0; k < 4; ++k) {
                    double r = (double)i / 5.0 * 0.1;
                    blue_arrow.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, blue_arrow.field_70165_t + blue_arrow.field_70159_w * (double)k / 4.0 + blue_arrow.field_70170_p.field_73012_v.nextGaussian() * r, blue_arrow.field_70163_u + blue_arrow.field_70181_x * (double)k / 4.0 + blue_arrow.field_70170_p.field_73012_v.nextGaussian() * r, blue_arrow.field_70161_v + blue_arrow.field_70179_y * (double)k / 4.0 + blue_arrow.field_70170_p.field_73012_v.nextGaussian() * r, 0.3607843220233917, 0.5921568870544434, 0.8784313797950745, new int[0]);
                }
            }
        }
    }

    private ItemStack findAmmunition(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return StackHelper.empty();
    }

    public void func_77615_a(ItemStack stack, @Nonnull World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        boolean isInfinite;
        float f;
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityplayer = (EntityPlayer)entityLiving;
        boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ItemStack ammunition = this.findAmmunition(entityplayer);
        int i = this.func_77626_a(stack) - timeLeft;
        if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)entityplayer, (int)i, (StackHelper.isNonNull(ammunition) || flag ? 1 : 0) != 0)) < 0) {
            return;
        }
        if (!StackHelper.isNonNull(ammunition)) {
            if (flag) {
                ammunition = new ItemStack(Items.field_151032_g);
            } else {
                return;
            }
        }
        if ((f = ItemCompoundBow.getArrowVelocityCustom(i)) < 0.1f) {
            return;
        }
        boolean bl = isInfinite = flag || entityplayer.field_71075_bZ.field_75098_d || ammunition.func_77973_b() instanceof ItemArrow && ((ItemArrow)ammunition.func_77973_b()).isInfinite(ammunition, stack, entityplayer);
        if (!worldIn.field_72995_K) {
            int k;
            ItemArrow itemarrow = (ItemArrow)(ammunition.func_77973_b() instanceof ItemArrow ? ammunition.func_77973_b() : Items.field_151032_g);
            EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, ammunition, (EntityLivingBase)entityplayer);
            entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 4.0f, 1.0f);
            if (f == 1.0f) {
                entityarrow.func_189654_d(true);
            }
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)f * 2.0);
            int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            if (j > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
            }
            if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                entityarrow.func_70240_a(k);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                entityarrow.func_70015_d(100);
            }
            stack.func_77972_a(1, (EntityLivingBase)entityplayer);
            if (isInfinite || entityplayer.field_71075_bZ.field_75098_d && (ammunition.func_77973_b() == Items.field_185166_h || ammunition.func_77973_b() == Items.field_185167_i)) {
                entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
            }
            if (worldIn.func_72838_d((Entity)entityarrow) && f == 1.0f) {
                PacketBlueArrow packetBlueArrow = new PacketBlueArrow(entityarrow.func_145782_y());
                ((WorldServer)worldIn).func_73039_n().func_151247_a((Entity)entityarrow, NetworkHandler.channels.get(Side.SERVER).generatePacketFrom((Object)packetBlueArrow));
            }
        }
        worldIn.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        if (!isInfinite && !entityplayer.field_71075_bZ.field_75098_d) {
            StackHelper.decrease(ammunition);
            if (StackHelper.getStacksize(ammunition) == 0) {
                entityplayer.field_71071_by.func_184437_d(ammunition);
            }
        }
        entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsTool() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getMaxMetadata() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register(this.tex);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createModel(int metadata) {
        return new PassthruModelItem(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseTexture() {
        return Textures.getSprite(this.tex[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addQuads(PassthruModelItem.ModelLayer model, ItemStack stack, World world, EntityLivingBase entityIn) {
        float v;
        int val = entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? ((double)(v = (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f) < 0.4 ? 1 : ((double)v < 0.82 ? 2 : (v < 1.0f ? 3 : 4))) : 0;
        model.addSprite(Textures.getSprite(this.tex[val]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postTextureRegister() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clearCaches() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean allowOverride() {
        return true;
    }

    static {
        MinecraftForge.EVENT_BUS.register(ItemCompoundBow.class);
    }

    @NetworkHandler.XUPacket
    public static class PacketBlueArrow
    extends XUPacketServerToClient {
        private int entityID;

        public PacketBlueArrow(int entityID) {
            this.entityID = entityID;
        }

        public PacketBlueArrow() {
        }

        @Override
        public void writeData() throws Exception {
            this.writeInt(this.entityID);
        }

        @Override
        public void readData(EntityPlayer player) {
            this.entityID = this.readInt();
        }

        @Override
        public Runnable doStuffClient() {
            return new ClientRunnable(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void run() {
                    Entity entityByID = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityID);
                    if (entityByID instanceof EntityArrow) {
                        blue_arrows.add((EntityArrow)entityByID);
                    }
                }
            };
        }
    }
}

