/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tweaker;

import com.rwtema.extrautils2.RunnableClient;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineRegistry;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.api.machine.XUMachineCrusher;
import com.rwtema.extrautils2.api.machine.XUMachineEnchanter;
import com.rwtema.extrautils2.api.machine.XUMachineGenerators;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.tweaker.GenericAction;
import com.rwtema.extrautils2.tweaker.IMachine;
import com.rwtema.extrautils2.tweaker.IMachineSlot;
import com.rwtema.extrautils2.tweaker.ObjWrapper;
import crafttweaker.annotations.ZenRegister;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="extrautilities2.Tweaker.IMachineRegistry")
public class IMachineRegistry {
    @ZenMethod
    public static IMachine createNewMachine(@Nonnull String name, int energyBufferSize, int energyTransferLimit, List<IMachineSlot> inputSlots, List<IMachineSlot> outputSlots, @Nonnull String frontTexture, @Nonnull String frontTextureActive) {
        return IMachineRegistry.createNewMachine(name, energyBufferSize, energyTransferLimit, inputSlots, outputSlots, frontTexture, frontTextureActive, 0xFFFFFF);
    }

    @ZenMethod
    public static IMachine createNewMachine(@Nonnull String name, int energyBufferSize, int energyTransferLimit, List<IMachineSlot> inputSlots, List<IMachineSlot> outputSlots, @Nonnull String frontTexture, @Nonnull String frontTextureActive, int color) {
        return IMachineRegistry.createNewMachine(name, energyBufferSize, energyTransferLimit, inputSlots, outputSlots, frontTexture, frontTextureActive, color, null, null, null, null, Machine.EnergyMode.USES_ENERGY);
    }

    @ZenMethod
    public static IMachine createNewGenerator(@Nonnull String name, int energyBufferSize, int energyTransferLimit, List<IMachineSlot> inputSlots, List<IMachineSlot> outputSlots, @Nonnull String frontTexture, @Nonnull String frontTextureActive) {
        return IMachineRegistry.createNewGenerator(name, energyBufferSize, energyTransferLimit, inputSlots, outputSlots, frontTexture, frontTextureActive, 0xFFFFFF);
    }

    @ZenMethod
    public static IMachine createNewGenerator(@Nonnull String name, int energyBufferSize, int energyTransferLimit, List<IMachineSlot> inputSlots, List<IMachineSlot> outputSlots, @Nonnull String frontTexture, @Nonnull String frontTextureActive, int color) {
        return IMachineRegistry.createNewMachine(name, energyBufferSize, energyTransferLimit, inputSlots, outputSlots, frontTexture, frontTextureActive, color, null, null, null, null, Machine.EnergyMode.GENERATES_ENERGY);
    }

    public static IMachine createNewMachine(@Nonnull String name, int energyBufferSize, int energyTransferLimit, List<IMachineSlot> inputSlots, List<IMachineSlot> outputSlots, final @Nonnull String frontTexture, final @Nonnull String frontTextureActive, int color, final @Nullable String textureTop, final @Nullable String textureBase, final @Nullable String textureBottom, final @Nullable String textureTopOverlay, Machine.EnergyMode energyMode) {
        if (name.indexOf(58) == -1) {
            name = "crafttweaker:" + name;
        }
        List<MachineSlotItem> itemInputs = inputSlots.stream().map(ObjWrapper::getInternal).filter(s -> s instanceof MachineSlotItem).map(s -> (MachineSlotItem)s).collect(Collectors.toList());
        List<MachineSlotFluid> fluidInputs = inputSlots.stream().map(ObjWrapper::getInternal).filter(s -> s instanceof MachineSlotFluid).map(s -> (MachineSlotFluid)s).collect(Collectors.toList());
        List<MachineSlotItem> itemOutputs = outputSlots.stream().map(ObjWrapper::getInternal).filter(s -> s instanceof MachineSlotItem).map(s -> (MachineSlotItem)s).collect(Collectors.toList());
        List<MachineSlotFluid> fluidOutputs = outputSlots.stream().map(ObjWrapper::getInternal).filter(s -> s instanceof MachineSlotFluid).map(s -> (MachineSlotFluid)s).collect(Collectors.toList());
        Machine machine = new Machine(name, energyBufferSize, energyTransferLimit, itemInputs, fluidInputs, itemOutputs, fluidOutputs, frontTexture, frontTextureActive, energyMode, color, textureTop, textureBase, textureBottom, textureTopOverlay);
        GenericAction.run(() -> MachineRegistry.register(machine), "Creating new machine: " + machine.name);
        new RunnableClient(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void run() {
                Textures.register(frontTexture, frontTextureActive, textureBase, textureBottom, textureTopOverlay, textureTop);
            }
        }.run();
        return new IMachine(machine);
    }

    @ZenMethod
    public static IMachine getMachine(String name) {
        Machine machine;
        if (name.indexOf(58) == -1) {
            name = "crafttweaker:" + name;
        }
        if ((machine = MachineRegistry.getMachine(name)) == null) {
            return null;
        }
        return new IMachine(machine);
    }

    @ZenMethod
    public static List<IMachine> getRegisteredMachineNames() {
        return MachineRegistry.getMachineValues().stream().map(IMachine::new).collect(Collectors.toList());
    }

    @ZenGetter(value="crusher")
    public static IMachine getCrusher() {
        return new IMachine(XUMachineCrusher.INSTANCE);
    }

    @ZenGetter(value="enchanter")
    public static IMachine getEnchanter() {
        return new IMachine(XUMachineEnchanter.INSTANCE);
    }

    @ZenGetter(value="generator_furnace")
    public static IMachine getFurnaceGenerator() {
        return new IMachine(XUMachineGenerators.FURNACE_GENERATOR);
    }

    @ZenGetter(value="generator_survivalist")
    public static IMachine getSurvivalistGenerator() {
        return new IMachine(XUMachineGenerators.SURVIVALIST_GENERATOR);
    }

    @ZenGetter(value="generator_culinary")
    public static IMachine getCulinaryGenerator() {
        return new IMachine(XUMachineGenerators.CULINARY_GENERATOR);
    }

    @ZenGetter(value="generator_potion")
    public static IMachine getPotionGenerator() {
        return new IMachine(XUMachineGenerators.POTION_GENERATOR);
    }

    @ZenGetter(value="generator_tnt")
    public static IMachine getTntGenerator() {
        return new IMachine(XUMachineGenerators.TNT_GENERATOR);
    }

    @ZenGetter(value="generator_lava")
    public static IMachine getLavaGenerator() {
        return new IMachine(XUMachineGenerators.LAVA_GENERATOR);
    }

    @ZenGetter(value="generator_pink")
    public static IMachine getPinkGenerator() {
        return new IMachine(XUMachineGenerators.PINK_GENERATOR);
    }

    @ZenGetter(value="generator_netherstar")
    public static IMachine getNetherstarGenerator() {
        return new IMachine(XUMachineGenerators.NETHERSTAR_GENERATOR);
    }

    @ZenGetter(value="generator_ender")
    public static IMachine getEnderGenerator() {
        return new IMachine(XUMachineGenerators.ENDER_GENERATOR);
    }

    @ZenGetter(value="generator_redstone")
    public static IMachine getRedstoneGenerator() {
        return new IMachine(XUMachineGenerators.REDSTONE_GENERATOR);
    }

    @ZenGetter(value="generator_overclock")
    public static IMachine getOverclockGenerator() {
        return new IMachine(XUMachineGenerators.OVERCLOCK_GENERATOR);
    }

    @ZenGetter(value="generator_dragon")
    public static IMachine getDragonGenerator() {
        return new IMachine(XUMachineGenerators.DRAGON_GENERATOR);
    }

    @ZenGetter(value="generator_ice")
    public static IMachine getIceGenerator() {
        return new IMachine(XUMachineGenerators.ICE_GENERATOR);
    }

    @ZenGetter(value="generator_death")
    public static IMachine getDeathGenerator() {
        return new IMachine(XUMachineGenerators.DEATH_GENERATOR);
    }

    @ZenGetter(value="generator_enchant")
    public static IMachine getEnchantGenerator() {
        return new IMachine(XUMachineGenerators.ENCHANT_GENERATOR);
    }

    @ZenGetter(value="generator_slime")
    public static IMachine getSlimeGenerator() {
        return new IMachine(XUMachineGenerators.SLIME_GENERATOR);
    }
}

