/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.helpers.IngredientHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.IngredientWrapper;
import mekanism.common.integration.crafttweaker.util.RemoveAllMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.outputs.PressurizedOutput;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.reaction")
@ZenRegister
public class Reaction {
    public static final String NAME = "Mekanism Reaction";

    @ZenMethod
    public static void addRecipe(IIngredient ingredientInput, ILiquidStack liquidInput, IGasStack gasInput, IItemStack itemOutput, IGasStack gasOutput, double energy, int duration) {
        if (IngredientHelper.checkNotNull(NAME, new IIngredient[]{ingredientInput, liquidInput, gasInput, itemOutput, gasOutput})) {
            FluidStack fluidInput = IngredientHelper.toFluid(liquidInput);
            GasStack gas = GasHelper.toGas(gasInput);
            PressurizedOutput output = new PressurizedOutput(CraftTweakerMC.getItemStack((IItemStack)itemOutput), GasHelper.toGas(gasOutput));
            ArrayList<PressurizedRecipe> recipes = new ArrayList<PressurizedRecipe>();
            for (ItemStack stack : CraftTweakerMC.getIngredient((IIngredient)ingredientInput).func_193365_a()) {
                recipes.add(new PressurizedRecipe(new PressurizedInput(stack, fluidInput, gas), output, energy, duration));
            }
            CrafttweakerIntegration.LATE_ADDITIONS.add(new AddMekanismRecipe<PressurizedInput, PressurizedOutput, PressurizedRecipe>(NAME, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER, recipes));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, IIngredient gasOutput, @Optional IIngredient itemInput, @Optional IIngredient liquidInput, @Optional IIngredient gasInput) {
        if (IngredientHelper.checkNotNull(NAME, itemOutput, gasOutput)) {
            CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveMekanismRecipe<PressurizedInput, PressurizedOutput, PressurizedRecipe>(NAME, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER, new IngredientWrapper(itemOutput, gasOutput), new IngredientWrapper(itemInput, liquidInput, gasInput)));
        }
    }

    @ZenMethod
    public static void removeAllRecipes() {
        CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveAllMekanismRecipe<PressurizedInput, PressurizedOutput, PressurizedRecipe>(NAME, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER));
    }
}

