/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.frequency.Frequency;
import mekanism.common.security.SecurityData;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.util.MekanismUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSecurityUpdate
implements IMessageHandler<SecurityUpdateMessage, IMessage> {
    public IMessage onMessage(SecurityUpdateMessage message, MessageContext context) {
        if (message.packetType == SecurityPacket.UPDATE && message.securityData != null) {
            MekanismClient.clientSecurityMap.put(message.playerUUID, message.securityData);
        }
        return null;
    }

    public static class SecurityUpdateMessage
    implements IMessage {
        public SecurityPacket packetType;
        public UUID playerUUID;
        public String playerUsername;
        public SecurityData securityData;

        public SecurityUpdateMessage() {
        }

        public SecurityUpdateMessage(SecurityPacket type, UUID uuid, SecurityData data) {
            this.packetType = type;
            if (this.packetType == SecurityPacket.UPDATE) {
                this.playerUUID = uuid;
                this.playerUsername = MekanismUtils.getLastKnownUsername(uuid);
                this.securityData = data;
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == SecurityPacket.UPDATE) {
                PacketHandler.writeString(dataStream, this.playerUUID.toString());
                PacketHandler.writeString(dataStream, this.playerUsername);
                if (this.securityData != null) {
                    dataStream.writeBoolean(true);
                    this.securityData.write(dataStream);
                } else {
                    dataStream.writeBoolean(false);
                }
            } else if (this.packetType == SecurityPacket.FULL) {
                ArrayList<SecurityFrequency> frequencies = new ArrayList<SecurityFrequency>();
                for (Frequency frequency : Mekanism.securityFrequencies.getFrequencies()) {
                    if (!(frequency instanceof SecurityFrequency)) continue;
                    frequencies.add((SecurityFrequency)frequency);
                }
                dataStream.writeInt(frequencies.size());
                for (SecurityFrequency securityFrequency : frequencies) {
                    PacketHandler.writeString(dataStream, securityFrequency.ownerUUID.toString());
                    PacketHandler.writeString(dataStream, MekanismUtils.getLastKnownUsername(securityFrequency.ownerUUID));
                    new SecurityData(securityFrequency).write(dataStream);
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = SecurityPacket.values()[dataStream.readInt()];
            if (this.packetType == SecurityPacket.UPDATE) {
                this.playerUUID = UUID.fromString(PacketHandler.readString(dataStream));
                this.playerUsername = PacketHandler.readString(dataStream);
                if (dataStream.readBoolean()) {
                    this.securityData = SecurityData.read(dataStream);
                }
                MekanismClient.clientUUIDMap.put(this.playerUUID, this.playerUsername);
            } else if (this.packetType == SecurityPacket.FULL) {
                MekanismClient.clientSecurityMap.clear();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    UUID uuid = UUID.fromString(PacketHandler.readString(dataStream));
                    String username = PacketHandler.readString(dataStream);
                    MekanismClient.clientSecurityMap.put(uuid, SecurityData.read(dataStream));
                    MekanismClient.clientUUIDMap.put(uuid, username);
                }
            }
        }
    }

    public static enum SecurityPacket {
        UPDATE,
        FULL;

    }
}

