/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import mekanism.common.config.MekanismConfig;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.ITier;

public enum PipeTier implements ITier
{
    BASIC(1000, 100),
    ADVANCED(4000, 400),
    ELITE(16000, 1600),
    ULTIMATE(64000, 6400);

    private final int baseCapacity;
    private final int basePull;
    private final BaseTier baseTier;

    private PipeTier(int capacity, int pullAmount) {
        this.baseCapacity = capacity;
        this.basePull = pullAmount;
        this.baseTier = BaseTier.values()[this.ordinal()];
    }

    public static PipeTier get(BaseTier tier) {
        for (PipeTier transmitter : PipeTier.values()) {
            if (transmitter.getBaseTier() != tier) continue;
            return transmitter;
        }
        return BASIC;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public int getPipeCapacity() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).PipeCapacity.val();
    }

    public int getPipePullAmount() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).PipePullAmount.val();
    }

    public int getBaseCapacity() {
        return this.baseCapacity;
    }

    public int getBasePull() {
        return this.basePull;
    }
}

