/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.classic.audio;

import ic2.api.classic.audio.IAudioPosition;
import ic2.api.classic.audio.ISoundProvider;
import ic2.api.classic.audio.MovingEntityAudioPosition;
import ic2.api.classic.audio.PositionSpec;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class AudioPosition
implements IAudioPosition {
    public World world;
    public Vec3d pos;

    public static IAudioPosition getFrom(Object obj, PositionSpec spec) {
        if (obj instanceof ISoundProvider) {
            return ((ISoundProvider)obj).getAudioPositon();
        }
        if (obj instanceof IAudioPosition) {
            return (IAudioPosition)obj;
        }
        if (obj instanceof Entity) {
            Entity e = (Entity)obj;
            if (spec == PositionSpec.Center) {
                return new AudioPosition(e.func_130014_f_(), e.func_174791_d());
            }
            return new MovingEntityAudioPosition(e);
        }
        if (obj instanceof TileEntity) {
            TileEntity te = (TileEntity)obj;
            return new AudioPosition(te.func_145831_w(), te.func_174877_v());
        }
        return null;
    }

    public AudioPosition(World world, BlockPos pos) {
        this(world, new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5));
    }

    public AudioPosition(World world, float x, float y, float z) {
        this(world, new Vec3d((double)x, (double)y, (double)z));
    }

    public AudioPosition(World world, Vec3d pos) {
        this.world = world;
        this.pos = pos;
    }

    @Override
    public Vec3d getPosition() {
        return this.pos;
    }

    @Override
    public World getWorld() {
        return this.world;
    }
}

