/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum Direction {
    YN(EnumFacing.DOWN),
    YP(EnumFacing.UP),
    XN(EnumFacing.NORTH),
    XP(EnumFacing.SOUTH),
    ZN(EnumFacing.WEST),
    ZP(EnumFacing.EAST);

    public final int xOffset;
    public final int yOffset;
    public final int zOffset;
    public final EnumFacing sideIndex;
    public static final Direction[] directions;
    public static final Rotation[] rotations;

    private Direction(EnumFacing side) {
        this.sideIndex = side;
        this.xOffset = side.func_82601_c();
        this.yOffset = side.func_96559_d();
        this.zOffset = side.func_82599_e();
    }

    public static Direction fromSideValue(int side) {
        return directions[side];
    }

    public static Direction fromEnumFacing(EnumFacing dir) {
        return Direction.fromSideValue(dir.func_176745_a());
    }

    public TileEntity applyToTileEntity(TileEntity te) {
        return this.applyTo(te.func_145831_w(), te.func_174877_v());
    }

    public TileEntity applyTo(World world, BlockPos pos) {
        BlockPos targetPos = pos.func_177972_a(this.toFacing());
        if (world.func_175667_e(targetPos)) {
            return world.func_175625_s(targetPos);
        }
        return null;
    }

    public Direction getInverse() {
        return directions[this.sideIndex.func_176734_d().func_176745_a()];
    }

    public int toSideValue() {
        return this.sideIndex.func_176745_a();
    }

    public EnumFacing toFacing() {
        return this.sideIndex;
    }

    public static EnumFacing rotate(EnumFacing facing, EnumFacing input) {
        if (facing.func_176740_k().func_176722_c()) {
            return rotations[facing.func_176745_a() - 2].func_185831_a(input);
        }
        if (input.func_176740_k() == EnumFacing.Axis.X) {
            return input;
        }
        return facing;
    }

    public static Tuple<Integer, Integer> getModelRotation(EnumFacing facing) {
        if (facing.func_176740_k().func_176722_c()) {
            return new Tuple((Object)0, (Object)(facing.func_176736_b() * 90));
        }
        return new Tuple((Object)(facing == EnumFacing.DOWN ? 90 : 270), (Object)0);
    }

    public static Tuple<Integer, Integer> getModelRotation(EnumFacing basement, EnumFacing rotation) {
        if (basement.func_176740_k().func_176720_b()) {
            return new Tuple((Object)(basement == EnumFacing.DOWN ? 90 : 270), (Object)(rotation.func_176736_b() * 90));
        }
        return new Tuple((Object)0, (Object)(rotation.func_176736_b() * 90));
    }

    static {
        rotations = Rotation.values();
        Direction[] array = Direction.values();
        directions = new Direction[array.length];
        Direction[] directionArray = array;
        int n = directionArray.length;
        for (int i = 0; i < n; ++i) {
            Direction dir;
            Direction.directions[dir.toSideValue()] = dir = directionArray[i];
        }
    }
}

