/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public final class RotationList
implements Iterable<EnumFacing> {
    static final RotationList[] ROTATIONS = RotationList.generateArray();
    public static RotationList DOWN = RotationList.ofFacings(EnumFacing.DOWN);
    public static RotationList UP = RotationList.ofFacings(EnumFacing.UP);
    public static RotationList NORTH = RotationList.ofFacings(EnumFacing.NORTH);
    public static RotationList SOUTH = RotationList.ofFacings(EnumFacing.SOUTH);
    public static RotationList EAST = RotationList.ofFacings(EnumFacing.EAST);
    public static RotationList WEST = RotationList.ofFacings(EnumFacing.WEST);
    public static RotationList VERTICAL = DOWN.add(UP);
    public static RotationList HORIZONTAL = RotationList.ofFacings(EnumFacing.field_176754_o);
    public static RotationList XAXIS = EAST.add(WEST);
    public static RotationList ZAXIS = NORTH.add(SOUTH);
    public static RotationList XYAXIS = XAXIS.add(VERTICAL);
    public static RotationList YZAXIS = ZAXIS.add(VERTICAL);
    public static RotationList PCORNER = SOUTH.add(EAST);
    public static RotationList NCORNER = NORTH.add(WEST);
    public static RotationList ALL = RotationList.ofFacings(EnumFacing.field_82609_l);
    public static RotationList EMPTY = RotationList.ofNumber(0);
    int code;
    int size;
    BlockPos offset;

    private RotationList() {
        throw new RuntimeException("NOT ALLOWED!");
    }

    private RotationList(int index) {
        this.code = (byte)MathHelper.func_76125_a((int)index, (int)0, (int)63);
        int value = 0;
        BlockPos.MutableBlockPos helper = new BlockPos.MutableBlockPos();
        for (EnumFacing facing : this) {
            value = (byte)(value + 1);
            helper.func_189536_c(facing);
        }
        this.offset = helper.func_185334_h();
        this.size = value;
    }

    public static RotationList ofFacings(EnumFacing ... facings) {
        return ROTATIONS[RotationList.toNumber(facings)];
    }

    public static RotationList ofFacings(Collection<EnumFacing> facings) {
        return ROTATIONS[RotationList.toNumber(facings)];
    }

    public static RotationList ofFlags(boolean ... flags) {
        return ROTATIONS[RotationList.toNumber(flags)];
    }

    public static RotationList ofNumber(int index) {
        return ROTATIONS[MathHelper.func_76125_a((int)index, (int)0, (int)63)];
    }

    public RotationList rotate(int amount) {
        int value = 0;
        for (int i = 0; i < 6; ++i) {
            if ((this.code & 1 << i) == 0) continue;
            value |= 1 << EnumFacing.func_82600_a((int)(i + amount)).func_176745_a();
        }
        return ROTATIONS[value & 0x3F];
    }

    public RotationList invert() {
        return ROTATIONS[63 - this.code];
    }

    public RotationList opposite() {
        int value = 0;
        for (int i = 0; i < 6; ++i) {
            if ((this.code & 1 << i) == 0) continue;
            value |= 1 << EnumFacing.func_82600_a((int)i).func_176734_d().func_176745_a();
        }
        return ROTATIONS[value & 0x3F];
    }

    public RotationList add(EnumFacing facing) {
        return ROTATIONS[this.code | 1 << facing.func_176745_a()];
    }

    public RotationList add(RotationList facings) {
        return ROTATIONS[this.code | facings.code];
    }

    public RotationList remove(EnumFacing facing) {
        return ROTATIONS[this.code & ~(1 << facing.func_176745_a())];
    }

    public RotationList remove(RotationList facings) {
        return ROTATIONS[this.code & ~facings.code];
    }

    public boolean contains(EnumFacing direction) {
        return (this.code & 1 << direction.func_176745_a()) != 0;
    }

    public boolean notContains(EnumFacing direction) {
        return (this.code & 1 << direction.func_176745_a()) == 0;
    }

    public RotationList invertFacing(EnumFacing facing) {
        if (this.contains(facing)) {
            return this.remove(facing).add(facing.func_176734_d());
        }
        return this;
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public int getCode() {
        return this.code;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.code == 0;
    }

    public boolean isFull() {
        return this.code == 63;
    }

    public Set<EnumFacing> toFacings() {
        EnumSet<EnumFacing> set = EnumSet.noneOf(EnumFacing.class);
        for (int i = 0; i < 6; ++i) {
            if ((this.code & 1 << i) == 0) continue;
            set.add(EnumFacing.func_82600_a((int)i));
        }
        return set;
    }

    public boolean[] toFlags() {
        boolean[] flags = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            if ((this.code & 1 << i) == 0) continue;
            flags[i] = true;
        }
        return flags;
    }

    public static int toNumber(EnumFacing ... facings) {
        int value = 0;
        for (EnumFacing facing : facings) {
            value |= 1 << facing.func_176745_a();
        }
        return value & 0x3F;
    }

    public static int toNumber(Collection<EnumFacing> facings) {
        int value = 0;
        for (EnumFacing facing : facings) {
            value |= 1 << facing.func_176745_a();
        }
        return value & 0x3F;
    }

    public static int toNumber(boolean ... facings) {
        return (facings[0] ? 1 : 0) << 0 | (facings[1] ? 1 : 0) << 1 | (facings[2] ? 1 : 0) << 2 | (facings[3] ? 1 : 0) << 3 | (facings[4] ? 1 : 0) << 4 | (facings[5] ? 1 : 0) << 5;
    }

    public static boolean[] toFlags(EnumFacing ... facings) {
        boolean[] array = new boolean[6];
        for (EnumFacing face : facings) {
            array[face.func_176745_a()] = true;
        }
        return array;
    }

    @Override
    public Iterator<EnumFacing> iterator() {
        return new Iterator<EnumFacing>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < 6 && (RotationList.this.code & 1 << this.index) == 0) {
                    ++this.index;
                }
                return this.index < 6;
            }

            @Override
            public EnumFacing next() {
                return EnumFacing.func_82600_a((int)this.index++);
            }
        };
    }

    public Iterable<EnumFacing> getRandomIterator() {
        return new Iterable<EnumFacing>(){

            @Override
            public Iterator<EnumFacing> iterator() {
                return new RandomIterator(RotationList.this.toFacings());
            }
        };
    }

    static RotationList[] generateArray() {
        RotationList[] rotations = new RotationList[64];
        for (int i = 0; i < 64; ++i) {
            rotations[i] = new RotationList(i);
        }
        return rotations;
    }

    private static class RandomIterator
    implements Iterator<EnumFacing> {
        LinkedList<EnumFacing> sides;

        public RandomIterator(Collection<EnumFacing> facings) {
            this.sides = new LinkedList<EnumFacing>(facings);
            Collections.shuffle(this.sides);
        }

        @Override
        public boolean hasNext() {
            return this.sides.size() > 0;
        }

        @Override
        public EnumFacing next() {
            return this.sides.remove();
        }
    }
}

