/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.output;

import ic2.api.classic.tile.IStackOutput;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.util.misc.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MultiSlotOutput
implements IStackOutput {
    ItemStack stack;
    int[] outputSlot;

    public MultiSlotOutput(ItemStack stack, int ... slots) {
        this.stack = stack;
        this.outputSlot = slots;
    }

    public MultiSlotOutput(NBTTagCompound nbt) {
        this(new ItemStack(nbt.func_74775_l("Item")), nbt.func_74759_k("Slots"));
    }

    @Override
    public boolean addToInventory(IHasInventory inventory) {
        if (this.stack.func_190926_b()) {
            return true;
        }
        for (int slot : this.outputSlot) {
            int left;
            if (inventory.getStackInSlot(slot).func_190926_b()) {
                inventory.setStackInSlot(slot, this.stack.func_77946_l());
                return true;
            }
            if (!StackUtil.isStackEqual(inventory.getStackInSlot(slot), this.stack, false, false) || (left = inventory.getStackInSlot(slot).func_77976_d() - inventory.getStackInSlot(slot).func_190916_E()) <= 0) continue;
            if (left >= this.stack.func_190916_E()) {
                inventory.getStackInSlot(slot).func_190917_f(this.stack.func_190916_E());
                return true;
            }
            int itemLeft = this.stack.func_190916_E() - left;
            this.stack.func_190920_e(itemLeft);
            inventory.getStackInSlot(slot).func_190920_e(inventory.getStackInSlot(slot).func_77976_d());
        }
        return false;
    }

    @Override
    public NBTTagCompound save() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74783_a("Slots", this.outputSlot);
        nbt.func_74782_a("Item", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        return nbt;
    }

    @Override
    public String getID() {
        return "Multi Output";
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }
}

