/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropSeedDropBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropBlueWheat
extends CropSeedDropBase {
    public CropBlueWheat() {
        super(new CropProperties(6, 3, 0, 0, 2, 0));
    }

    @Override
    public String getDiscoveredBy() {
        return "Daenara";
    }

    @Override
    public ItemStack getSeed(ICropTile tile) {
        return new ItemStack(Items.field_151014_N);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state == 7) {
            return this.getSprite("bc")[86];
        }
        return this.getSprite("bc")[1 + state];
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getTerrainHumidity() >= 8 && cropTile.getCurrentSize() < 7;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 7;
    }

    @Override
    public int getWeightInfluences(ICropTile crop, int humidity, int nutrients, int air) {
        return (int)((double)humidity * 1.8 + (double)nutrients + (double)air * 0.8);
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Blue", "Lapis", "Wheat"};
    }

    @Override
    public String getId() {
        return "BlueWheat";
    }

    @Override
    public double dropGainChance() {
        return 0.5;
    }

    @Override
    public int getMaxSize() {
        return 7;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b());
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        return 600;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 2;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 7;
    }
}

