/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.IC2;
import ic2.core.block.crop.crops.CropCardBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropCacti
extends CropCardBase {
    public CropCacti() {
        super(new CropProperties(2, 0, 0, 4, 4, 0));
    }

    @Override
    public String getDiscoveredBy() {
        return "SpwnX";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        return this.getSprite("bc")[57 + state];
    }

    @Override
    public String getId() {
        return "Cacti";
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        int count = 1;
        if (IC2.random.nextInt(3) == 0) {
            count = 2;
        }
        return new ItemStack((Block)Blocks.field_150434_aF, count);
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Green", "Cacti", "Thorns"};
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getTerrainAirQuality() >= 2 && cropTile.getCurrentSize() < 4;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 4;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 4;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        return 300;
    }

    @Override
    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        if (entity instanceof EntityItem) {
            return super.onEntityCollision(crop, entity);
        }
        if (!this.getWorld((ICropTile)crop).field_72995_K) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
        return super.onEntityCollision(crop, entity);
    }

    @Override
    public int getWeightInfluences(ICropTile crop, int humidity, int nutrients, int air) {
        int count = super.getWeightInfluences(crop, humidity, nutrients, air);
        count = (int)((float)count + 10.0f * this.getBiomeTemperature(crop));
        return count;
    }

    public float getBiomeTemperature(ICropTile crop) {
        return this.getWorld(crop).func_180494_b(crop.getLocation()).func_180626_a(crop.getLocation()) - 0.5f;
    }
}

