/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropCardBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropMushroom
extends CropCardBase {
    boolean red;

    public CropMushroom(boolean red) {
        super(new CropProperties(2, 0, 4, 0, 0, 4));
        this.red = red;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        int base = 51;
        if (this.red) {
            base += 3;
        }
        return this.getSprite("bc")[base + state];
    }

    @Override
    public String[] getAttributes() {
        String color = this.red ? "Red" : "Brown";
        return new String[]{color, "Food", "Mushroom"};
    }

    @Override
    public String getId() {
        return this.red ? "RedMushroom" : "BrownMushroom";
    }

    @Override
    public int getMaxSize() {
        return 3;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        if (crop.getCurrentSize() == 3) {
            return this.red ? new ItemStack((Block)Blocks.field_150337_Q) : new ItemStack((Block)Blocks.field_150338_P);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 3 && cropTile.getTerrainHumidity() > 0;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() >= 3;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 3;
    }
}

