/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropCardBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropReed
extends CropCardBase {
    public CropReed() {
        super(new CropProperties(2, 0, 0, 1, 0, 2));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        return this.getSprite("bc")[27 + state];
    }

    @Override
    public String getId() {
        return "Reed";
    }

    @Override
    public String getDiscoveredBy() {
        return "Notch";
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Reed"};
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 3;
    }

    @Override
    public int getWeightInfluences(ICropTile crop, int humidity, int nutrients, int air) {
        return (int)((float)humidity * 1.2f + (float)nutrients + (float)air * 0.8f);
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() > 1;
    }

    @Override
    public int getMaxSize() {
        return 3;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Items.field_151120_aE, crop.getCurrentSize() - 1);
    }

    @Override
    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        return false;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        return 200;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 3;
    }
}

