/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropSeedDropBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropWheat
extends CropSeedDropBase {
    public CropWheat() {
        super(new CropProperties(1, 0, 4, 0, 0, 2));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        return this.getSprite("bc")[1 + state];
    }

    @Override
    public String getId() {
        return "Wheat";
    }

    @Override
    public String getDiscoveredBy() {
        return "Notch";
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Yellow", "Food", "Wheat"};
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 7 && cropTile.getLightLevel() >= 9;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 7;
    }

    @Override
    public int getMaxSize() {
        return 7;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Items.field_151015_O, 1);
    }

    @Override
    public ItemStack getSeed(ICropTile tile) {
        return new ItemStack(Items.field_151014_N);
    }

    @Override
    public ItemStack getSeeds(ICropTile crop) {
        if (crop.getStatGain() <= 1 && crop.getStatGrowth() <= 1 && crop.getStatResistance() <= 1) {
            return new ItemStack(Items.field_151014_N);
        }
        return super.getSeeds(crop);
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 2;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 7;
    }
}

