/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.high;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.classic.tile.machine.ISecondaryProgressMachine;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.comparator.comparators.ComparatorSecondaryProgress;
import ic2.core.block.base.util.comparator.comparators.ComparatorUranIngridientAmount;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.base.util.info.SecondaryProgressInfo;
import ic2.core.block.machine.high.container.ContainerUraniumEnricher;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileEntityUraniumEnricher
extends TileEntityElecMachine
implements ITickable,
IProgressMachine,
IHasGui,
ISecondaryProgressMachine {
    @NetworkField(index=7)
    public byte type = 0;
    @NetworkField(index=8, compression=NetworkField.BitLevel.Bit16)
    public int amount = 0;
    @NetworkField(index=9, compression=NetworkField.BitLevel.Bit16)
    public int uranProgress = 0;
    @NetworkField(index=10, compression=NetworkField.BitLevel.Bit8)
    public int itemProgress = 0;
    public static List<IUranium> RECIPE_LIST = new ArrayList<IUranium>();
    public static ItemStack URANIUM_INGOT_REFERENCE = null;
    public static final int maxUranProgress = 1000;
    public static final int maxItemProgress = 100;

    public TileEntityUraniumEnricher() {
        super(3, 512);
        this.maxEnergy = 100000;
        this.addGuiFields("type", "amount", "uranProgress", "itemProgress");
        this.addInfos(new ProgressInfo(this), new SecondaryProgressInfo(this));
        TileEntityUraniumEnricher.getReference();
    }

    public static ItemStack getReference() {
        if (URANIUM_INGOT_REFERENCE == null) {
            URANIUM_INGOT_REFERENCE = Ic2Items.uraniumIngot.func_77946_l();
        }
        return URANIUM_INGOT_REFERENCE;
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Import, 0, 1);
        handler.registerDefaultSlotAccess(AccessRule.Export, 2);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), 0, 1);
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), 2);
        handler.registerInputFilter(CommonFilters.uranFilter, 0);
        handler.registerInputFilter(CommonFilters.uranEnricher, 1);
        handler.registerSlotType(SlotType.Input, 0);
        handler.registerSlotType(SlotType.SecondInput, 1);
        handler.registerSlotType(SlotType.Output, 2);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
        manager.addComparatorMode(new ComparatorSecondaryProgress(this));
        manager.addComparatorMode(new ComparatorUranIngridientAmount(this));
    }

    @Override
    public float getProgress() {
        return this.uranProgress;
    }

    @Override
    public float getMaxProgress() {
        return 1000.0f;
    }

    @Override
    public float getSecondaryProgress() {
        return this.itemProgress;
    }

    @Override
    public float getMaxSecondaryProgress() {
        return 100.0f;
    }

    @Override
    public boolean supportsNotify() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.itemProgress = nbt.func_74762_e("ItemProgress");
        this.uranProgress = nbt.func_74762_e("UranProgress");
        this.amount = nbt.func_74762_e("Amount");
        this.type = (byte)nbt.func_74762_e("Type");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("ItemProgress", this.itemProgress);
        nbt.func_74768_a("UranProgress", this.uranProgress);
        nbt.func_74768_a("Amount", this.amount);
        nbt.func_74768_a("Type", (int)this.type);
        return nbt;
    }

    public void func_73660_a() {
        this.updateNeighbors();
        boolean active = false;
        boolean notify = false;
        if (StackUtil.isStackEqual((ItemStack)this.inventory.get(0), URANIUM_INGOT_REFERENCE) && this.type > 0 && this.amount >= 100) {
            IUranium uranType = this.getType();
            if (uranType != null) {
                int cost = uranType.getIngridientCost();
                ItemStack ingot = uranType.getUraniumIngot();
                if (this.hasEnergy(cost) && (((ItemStack)this.inventory.get(2)).func_190926_b() || StackUtil.isStackEqual((ItemStack)this.inventory.get(2), ingot) && ((ItemStack)this.inventory.get(2)).func_190916_E() + 1 <= ((ItemStack)this.inventory.get(2)).func_77976_d())) {
                    active = true;
                    this.useEnergy(cost);
                    ++this.uranProgress;
                    if (this.uranProgress >= 1000) {
                        this.uranProgress = 0;
                        this.amount -= 100;
                        if (this.amount <= 0) {
                            this.amount = 0;
                            this.type = 0;
                            this.getNetwork().updateTileGuiField(this, "type");
                        }
                        this.getNetwork().updateTileGuiField(this, "amount");
                        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
                            this.inventory.set(2, (Object)ingot.func_77946_l());
                        } else if (StackUtil.isStackEqual((ItemStack)this.inventory.get(2), ingot)) {
                            ((ItemStack)this.inventory.get(2)).func_190917_f(1);
                        }
                        ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                        notify = true;
                    }
                    this.getNetwork().updateTileGuiField(this, "uranProgress");
                }
            } else if (this.uranProgress != 0) {
                this.uranProgress = 0;
                this.getNetwork().updateTileGuiField(this, "uranProgress");
            }
        } else if (this.uranProgress != 0) {
            this.uranProgress = 0;
            this.getNetwork().updateTileGuiField(this, "uranProgress");
        }
        if (this.isMatchingType((ItemStack)this.inventory.get(1))) {
            byte itemType = TileEntityUraniumEnricher.getTypeFromItem((ItemStack)this.inventory.get(1));
            IUranium uranType = TileEntityUraniumEnricher.getType(itemType);
            if ((this.type == 0 || this.type == itemType) && this.amount + uranType.getIngrientPoints() <= 1000 && this.hasEnergy(100)) {
                active = true;
                ++this.itemProgress;
                this.useEnergy(100);
                if (this.itemProgress >= 100) {
                    this.itemProgress = 0;
                    ((ItemStack)this.inventory.get(1)).func_190918_g(1);
                    if (this.type == 0) {
                        this.type = itemType;
                        this.getNetwork().updateTileGuiField(this, "type");
                    }
                    this.amount += uranType.getIngrientPoints();
                    if (this.amount > 1000) {
                        this.amount = 1000;
                    }
                    this.getNetwork().updateTileGuiField(this, "amount");
                    notify = true;
                }
                this.getNetwork().updateTileGuiField(this, "itemProgress");
            }
        } else if (this.itemProgress != 0) {
            this.itemProgress = 0;
            this.getNetwork().updateTileGuiField(this, "itemProgress");
        }
        this.setActive(active);
        this.updateComparators();
        if (notify) {
            this.notifyNeighbors();
        }
    }

    public boolean isMatchingType(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        IUranium type = this.getType();
        if (type != null) {
            return StackUtil.isStackEqual(type.getIngridient(), stack);
        }
        for (int i = 0; i < RECIPE_LIST.size(); ++i) {
            IUranium targetType = RECIPE_LIST.get(i);
            if (!targetType.isReEnrichedUran() || !StackUtil.isStackEqual(targetType.getIngridient(), stack)) continue;
            return true;
        }
        return false;
    }

    public static byte getTypeFromItem(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        for (int i = 0; i < RECIPE_LIST.size(); ++i) {
            IUranium targetType = RECIPE_LIST.get(i);
            if (!targetType.isReEnrichedUran() || !StackUtil.isStackEqual(targetType.getIngridient(), fuel)) continue;
            return (byte)i;
        }
        return 0;
    }

    public static IUranium getType(int type) {
        if (type == 0 || RECIPE_LIST.size() <= type) {
            return null;
        }
        return RECIPE_LIST.get(type);
    }

    public IUranium getType() {
        if (this.type == 0 || RECIPE_LIST.size() <= this.type) {
            return null;
        }
        return RECIPE_LIST.get(this.type);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerUraniumEnricher(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.EnricherGui.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    public float getAmount() {
        float result = (float)this.amount / 1000.0f;
        if (result > 1.0f) {
            result = 1.0f;
        }
        return result;
    }

    public float getUranProgress() {
        float result = (float)this.uranProgress / 1000.0f;
        if (result > 1.0f) {
            result = 1.0f;
        }
        return result;
    }

    public float getItemProgress() {
        float result = (float)this.itemProgress / 100.0f;
        if (result > 1.0f) {
            result = 1.0f;
        }
        return result;
    }
}

