/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.recipes.entries;

import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public class RecipeOutputRandom
extends MachineOutput {
    int minValue;
    int maxValue;
    ItemStack stack;

    public RecipeOutputRandom(ItemStack item, int min, int max) {
        super(null, StackUtil.copyWithSize(item, max));
        this.minValue = min;
        this.maxValue = max;
        this.stack = item.func_77946_l();
    }

    @Override
    public MachineOutput copy() {
        return new RecipeOutputRandom(this.stack.func_77946_l(), this.minValue, this.maxValue);
    }

    @Override
    public MachineOutput overrideOutput(List<ItemStack> list) {
        if (!this.canOverride()) {
            return this.copy();
        }
        return new RecipeOutputRandom(list.get(0).func_77946_l(), this.minValue, this.maxValue);
    }

    @Override
    public List<ItemStack> getRecipeOutput(Random rand, NBTTagCompound subData) {
        int value = MathHelper.func_76125_a((int)rand.nextInt(this.maxValue + 1), (int)this.minValue, (int)this.maxValue);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(StackUtil.copyWithSize(this.stack, value));
        return list;
    }

    @Override
    public List<ItemStack> getAllOutputs() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(StackUtil.copyWithSize(this.stack, this.maxValue));
        return list;
    }

    @Override
    public void onJEIInfo(BiConsumer<String, Vec3i> consumer) {
        super.onJEIInfo(consumer);
        consumer.accept(Ic2InfoLang.randomAmount.getLocalizedFormatted(this.minValue, this.maxValue), belowOutputLeft);
    }
}

