/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.recipes.managers;

import ic2.api.classic.recipe.machine.IRareEarthExtractorRecipeList;
import ic2.core.util.helpers.ItemWithMeta;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class RareEarthRecipeManager
implements IRareEarthExtractorRecipeList {
    Map<ItemWithMeta, Float> recipeMap = new LinkedHashMap<ItemWithMeta, Float>();
    List<IRareEarthExtractorRecipeList.EarthEntry> recipeList = new ArrayList<IRareEarthExtractorRecipeList.EarthEntry>();

    @Override
    public void registerValue(float value, ItemStack ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        for (ItemStack item : items) {
            if (item.func_190926_b()) continue;
            this.recipeMap.put(new ItemWithMeta(item), Float.valueOf(value));
            this.recipeList.add(new IRareEarthExtractorRecipeList.EarthEntry(value, item));
        }
    }

    @Override
    public float getEarthValue(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0.0f;
        }
        Float value = this.recipeMap.get(new ItemWithMeta(stack));
        if (value == null) {
            value = Float.valueOf(0.0f);
        }
        return value.floatValue();
    }

    @Override
    public List<IRareEarthExtractorRecipeList.EarthEntry> getRecipeList() {
        return this.recipeList;
    }

    @Override
    public void removeEntry(ItemStack ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        for (ItemStack item : items) {
            this.recipeMap.remove(new ItemWithMeta(item));
        }
        this.recipeList = new ArrayList<IRareEarthExtractorRecipeList.EarthEntry>(this.recipeMap.size());
        for (Map.Entry entry : this.recipeMap.entrySet()) {
            this.recipeList.add(new IRareEarthExtractorRecipeList.EarthEntry(((Float)entry.getValue()).floatValue(), ((ItemWithMeta)entry.getKey()).toStack()));
        }
    }
}

