/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.render.model;

import ic2.core.RotationList;
import ic2.core.block.wiring.BlockCable;
import ic2.core.platform.textures.Ic2Models;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.util.helpers.BlockStateContainerIC2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class ModelCable
extends BaseModel {
    List<BakedQuad>[] quads = this.createList(64);
    List<BakedQuad>[] anchorQuads = this.createList(64);
    Map<Integer, List<BakedQuad>> comboQuads = new HashMap<Integer, List<BakedQuad>>();
    IBlockState state;
    TextureAtlasSprite sprite;

    public ModelCable(IBlockState block, TextureAtlasSprite texture) {
        super(Ic2Models.getBlockTransforms());
        this.state = block;
        this.sprite = texture;
    }

    @Override
    public void init() {
        BlockCable cable = (BlockCable)this.state.func_177230_c();
        this.setParticalTexture(cable.getParticleTexture(this.state));
        int min = cable.getMinPixels(this.state);
        int max = cable.getMaxPixels(this.state);
        Map<EnumFacing, BakedQuad> coreQuads = this.generateCoreQuads(cable, min, max);
        EnumMap<EnumFacing, List<BakedQuad>> sideQuads = new EnumMap<EnumFacing, List<BakedQuad>>(EnumFacing.class);
        EnumMap<EnumFacing, List<BakedQuad>> anchorQuadList = new EnumMap<EnumFacing, List<BakedQuad>>(EnumFacing.class);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            sideQuads.put(side, this.generateQuadsForSide(cable, side, min, max));
            anchorQuadList.put(side, this.generateQuadsForAnchor(this.sprite, side, min, max));
        }
        for (int i = 0; i < 64; ++i) {
            RotationList rotation = RotationList.ofNumber(i);
            List<BakedQuad> quadList = this.quads[i];
            for (EnumFacing side : rotation) {
                quadList.addAll((Collection)sideQuads.get(side));
                this.anchorQuads[i].addAll((Collection)anchorQuadList.get(side));
            }
            for (EnumFacing side : rotation.invert()) {
                quadList.add(coreQuads.get(side));
            }
        }
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null) {
            if (!(state instanceof BlockStateContainerIC2.IC2BlockState)) {
                return this.quads[0];
            }
            Vec3i vec = (Vec3i)((BlockStateContainerIC2.IC2BlockState)state).getData();
            if (vec.func_177956_o() > 0) {
                List<BakedQuad> list = this.comboQuads.get(vec.func_177952_p());
                if (list == null) {
                    list = new ArrayList<BakedQuad>(this.quads[vec.func_177958_n()]);
                    list.addAll(this.anchorQuads[vec.func_177956_o()]);
                    this.comboQuads.put(vec.func_177952_p(), list);
                }
                return list;
            }
            return this.quads[vec.func_177958_n()];
        }
        return this.getEmptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getCamera(), (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    private Map<EnumFacing, BakedQuad> generateCoreQuads(BlockCable cable, int min, int max) {
        Vector3f minF = new Vector3f((float)min, (float)min, (float)min);
        Vector3f maxF = new Vector3f((float)max, (float)max, (float)max);
        BlockPartFace face = new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, min, max, max}, 0));
        EnumMap<EnumFacing, BakedQuad> quads = new EnumMap<EnumFacing, BakedQuad>(EnumFacing.class);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            quads.put(side, this.getBakery().func_178414_a(minF, maxF, face, this.func_177554_e(), side, ModelRotation.X0_Y0, null, true, true));
        }
        return quads;
    }

    private List<BakedQuad> generateQuadsForAnchor(TextureAtlasSprite sprite, EnumFacing facing, int min, int max) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Pair<Vector3f, Vector3f> position = this.getPosForSide(facing, min, max);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (side.func_176734_d() == facing) continue;
            BlockPartFace face = null;
            face = side == facing ? new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, min, max, max}, 0)) : (facing.func_176740_k() == EnumFacing.Axis.Z && side.func_176740_k() == EnumFacing.Axis.X ? new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{max, min, 16.0f, max}, 0)) : this.getFace(facing, min, max));
            quads.add(this.getBakery().func_178414_a((Vector3f)position.getKey(), (Vector3f)position.getValue(), face, sprite, side, ModelRotation.X0_Y0, null, true, true));
        }
        return quads;
    }

    private List<BakedQuad> generateQuadsForSide(BlockCable cable, EnumFacing facing, int min, int max) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Pair<Vector3f, Vector3f> position = this.getPosForSide(facing, min, max);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (side.func_176734_d() == facing) continue;
            BlockPartFace face = null;
            face = side == facing ? new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, min, max, max}, 0)) : (facing.func_176740_k() == EnumFacing.Axis.Z && side.func_176740_k() == EnumFacing.Axis.X ? new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{max, min, 16.0f, max}, 0)) : this.getFace(facing, min, max));
            quads.add(this.getBakery().func_178414_a((Vector3f)position.getKey(), (Vector3f)position.getValue(), face, cable.getTextureFromState(this.state, side), side, ModelRotation.X0_Y0, null, true, true));
        }
        return quads;
    }

    private Pair<Vector3f, Vector3f> getPosForSide(EnumFacing facing, int min, int max) {
        switch (facing) {
            case DOWN: {
                return Pair.of((Object)new Vector3f((float)min, 0.0f, (float)min), (Object)new Vector3f((float)max, (float)min, (float)max));
            }
            case UP: {
                return Pair.of((Object)new Vector3f((float)min, (float)max, (float)min), (Object)new Vector3f((float)max, 16.0f, (float)max));
            }
            case NORTH: {
                return Pair.of((Object)new Vector3f((float)min, (float)min, 0.0f), (Object)new Vector3f((float)max, (float)max, (float)min));
            }
            case SOUTH: {
                return Pair.of((Object)new Vector3f((float)min, (float)min, (float)max), (Object)new Vector3f((float)max, (float)max, 16.0f));
            }
            case WEST: {
                return Pair.of((Object)new Vector3f(0.0f, (float)min, (float)min), (Object)new Vector3f((float)min, (float)max, (float)max));
            }
            case EAST: {
                return Pair.of((Object)new Vector3f((float)max, (float)min, (float)min), (Object)new Vector3f(16.0f, (float)max, (float)max));
            }
        }
        return Pair.of((Object)new Vector3f((float)min, (float)min, (float)min), (Object)new Vector3f((float)max, (float)max, (float)max));
    }

    private BlockPartFace getFace(EnumFacing facing, int min, int max) {
        switch (facing) {
            case DOWN: {
                return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, max, max, 16.0f}, 0));
            }
            case UP: {
                return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, 0.0f, max, min}, 0));
            }
            case NORTH: {
                return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, 0.0f, max, min}, 0));
            }
            case SOUTH: {
                return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, max, max, 16.0f}, 0));
            }
            case WEST: {
                return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{0.0f, min, min, max}, 0));
            }
            case EAST: {
                return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{max, min, 16.0f, max}, 0));
            }
        }
        return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0));
    }
}

