/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.fluid;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.obj.ITankListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public final class LayeredFluidTank
implements IFluidHandler,
IFluidTank,
INetworkFieldData {
    List<ITankListener> listeners = new ArrayList<ITankListener>();
    Map<Fluid, FluidStack> fluids = new LinkedHashMap<Fluid, FluidStack>();
    int fluidStored = 0;
    int capacity;
    boolean canFill = true;
    boolean canDrain = true;
    IFluidTankProperties[] tankProperties;

    public LayeredFluidTank(int capacity, Map<Fluid, FluidStack> fluid) {
        this(capacity);
        this.fluids.putAll(fluid);
    }

    public void addListener(ITankListener listener) {
        this.listeners.add(listener);
    }

    public LayeredFluidTank(int capacity) {
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public boolean canFill() {
        return this.canFill;
    }

    public void setCanFill(boolean canFill) {
        this.canFill = canFill;
    }

    public boolean canDrain() {
        return this.canDrain;
    }

    public void setCanDrain(boolean canDrain) {
        this.canDrain = canDrain;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.tankProperties == null || this.tankProperties.length != this.fluids.size()) {
            if (this.fluids.isEmpty()) {
                this.tankProperties = new IFluidTankProperties[1];
                this.tankProperties[0] = new FluidTankProperties(null, this.capacity, this.canFill(), this.canDrain());
            } else {
                this.tankProperties = new IFluidTankProperties[this.fluids.size()];
                int counter = 0;
                for (FluidStack stack : this.fluids.values()) {
                    this.tankProperties[counter] = new FluidTankProperties(stack, this.capacity, this.canFill(), this.canDrain());
                    ++counter;
                }
            }
        }
        return this.tankProperties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || this.capacity - this.fluidStored <= 0) {
            return 0;
        }
        FluidStack found = this.fluids.get(resource.getFluid());
        if (!doFill) {
            if (found == null) {
                return Math.min(resource.amount, this.capacity - this.fluidStored);
            }
            if (found.isFluidEqual(resource)) {
                return Math.min(resource.amount, this.capacity - this.fluidStored);
            }
            return 0;
        }
        if (found == null) {
            int room;
            if (this.fluids.isEmpty()) {
                this.tankProperties = null;
            }
            if ((room = this.capacity - this.fluidStored) < resource.amount) {
                FluidStack copy = FluidHelper.copyWithSize(resource, room);
                this.fluids.put(copy.getFluid(), copy);
                this.fluidStored += copy.amount;
                this.onTankChanged();
                return copy.amount;
            }
            this.fluids.put(resource.getFluid(), FluidHelper.copyFluid(resource));
            this.fluidStored += resource.amount;
            this.onTankChanged();
            return resource.amount;
        }
        if (!found.isFluidEqual(resource)) {
            return 0;
        }
        int adding = Math.min(resource.amount, this.capacity - this.fluidStored);
        found.amount += adding;
        this.fluidStored += adding;
        this.onTankChanged();
        return adding;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        FluidStack found = this.fluids.get(resource.getFluid());
        if (found == null || !found.isFluidEqual(resource)) {
            return null;
        }
        FluidStack drained = FluidHelper.copyWithSize(found, Math.min(found.amount, resource.amount));
        if (doDrain) {
            found.amount -= drained.amount;
            this.fluidStored -= drained.amount;
            if (found.amount <= 0) {
                this.fluids.remove(found.getFluid());
            }
            this.onTankChanged();
        }
        return drained;
    }

    protected void onTankChanged() {
        for (ITankListener list : this.listeners) {
            list.onTankChanged(this);
        }
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain <= 0 || this.fluids.isEmpty()) {
            return null;
        }
        FluidStack first = this.fluids.values().iterator().next();
        FluidStack drained = FluidHelper.copyWithSize(first, Math.min(maxDrain, first.amount));
        if (doDrain) {
            first.amount -= drained.amount;
            this.fluidStored -= drained.amount;
            if (first.amount <= 0) {
                this.fluids.remove(first.getFluid());
            }
            this.onTankChanged();
        }
        return drained;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.fluids.clear();
        this.fluidStored = 0;
        this.tankProperties = null;
        NBTTagList list = nbt.func_150295_c("FluidData", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)list.func_150305_b(i));
            if (fluid == null) continue;
            this.fluids.put(fluid.getFluid(), fluid);
            this.fluidStored += fluid.amount;
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (FluidStack fluid : this.fluids.values()) {
            list.func_74742_a((NBTBase)fluid.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("FluidData", (NBTBase)list);
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.capacity = buffer.readInt();
        this.fluidStored = 0;
        this.fluids.clear();
        this.tankProperties = null;
        int expected = buffer.readShort();
        for (int i = 0; i < expected; ++i) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.readNBTData());
            if (fluid == null) continue;
            this.fluids.put(fluid.getFluid(), fluid);
            this.fluidStored += fluid.amount;
        }
    }

    @Override
    public void write(IOutputBuffer buffer) {
        buffer.writeInt(this.capacity);
        buffer.writeShort((short)this.fluids.size());
        for (FluidStack fluid : this.fluids.values()) {
            buffer.writeNBTData(fluid.writeToNBT(new NBTTagCompound()));
        }
    }

    @Nullable
    public FluidStack getFluid() {
        return this.fluids.isEmpty() ? null : this.fluids.values().iterator().next();
    }

    public int getFluidAmount() {
        return this.fluidStored;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }
}

