/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.base;

import ic2.core.block.base.util.info.misc.IPumpTile;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.util.math.Box2D;
import ic2.core.util.math.Vec2i;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PumpChargeComp
extends GuiComponent {
    IPumpTile pump;
    Vec2i texPos;
    Vec2i barPos;
    Vec2i glassPos;

    public PumpChargeComp(IPumpTile tile, Box2D box, Vec2i tex, Vec2i bar, Vec2i glass) {
        super(box);
        this.pump = tile;
        this.texPos = tex;
        this.barPos = bar;
        this.glassPos = glass;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        float per = (float)this.pump.getPumpCharge() / (float)this.pump.getMaxPumpCharge();
        if (per > 1.0f) {
            per = 1.0f;
        }
        Box2D box = this.getPosition();
        int maxY = box.getHeight();
        int maxX = box.getLenght();
        int lvl = (int)(per * (float)maxY);
        int xPos = x + box.getX();
        int yPos = y + box.getY();
        gui.func_73729_b(xPos, yPos + (maxY - 6 - lvl), this.barPos.getX(), this.barPos.getY(), maxX, 5);
        if (lvl > 0) {
            gui.func_73729_b(xPos, yPos + (maxY - 1 - lvl), this.texPos.getX(), this.texPos.getY(), maxX, lvl);
        }
        gui.func_73729_b(xPos, yPos -= 6, this.glassPos.getX(), this.glassPos.getY(), maxX, maxY + 5);
    }
}

