/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.special;

import ic2.core.block.machine.low.TileEntitySoundBeacon;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class SoundBeaconComp
extends GuiComponent {
    TileEntitySoundBeacon beacon;

    public SoundBeaconComp(TileEntitySoundBeacon tile) {
        super(Ic2GuiComp.nullBox);
        this.beacon = tile;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.FrontgroundDraw);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        int tileEffect = (int)(this.beacon.tileEffect * 100.0f);
        int itemEffect = (int)(this.beacon.itemEffect * 100.0f);
        int armorEffect = (int)(this.beacon.armorEffect * 100.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)30.0f, (float)38.0f, (float)0.0f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.0f);
        gui.drawString(Ic2GuiLang.beaconTile, 0, -30, 0x404040);
        gui.drawString(Ic2GuiLang.beaconRange.getLocalizedFormatted(this.beacon.tileRange), 0, -20, 0x404040);
        gui.drawString(Ic2GuiLang.beaconEffect.getLocalizedFormatted(tileEffect + "%"), 0, -10, 0x404040);
        gui.drawString(Ic2GuiLang.beaconItem, 100, -30, 0x404040);
        gui.drawString(Ic2GuiLang.beaconRange.getLocalizedFormatted(this.beacon.itemRange), 100, -20, 0x404040);
        gui.drawString(Ic2GuiLang.beaconEffect.getLocalizedFormatted(itemEffect + "%"), 100, -10, 0x404040);
        gui.drawString(Ic2GuiLang.beaconArmor, 200, -30, 0x404040);
        gui.drawString(Ic2GuiLang.beaconRange.getLocalizedFormatted(this.beacon.armorRange), 200, -20, 0x404040);
        gui.drawString(Ic2GuiLang.beaconEffect.getLocalizedFormatted(armorEffect + "%"), 200, -10, 0x404040);
        GL11.glPopMatrix();
    }
}

