/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.transport.wrapper;

import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.transport.ICachedInventory;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class ChachedInventory
implements IHasInventory,
ICachedInventory {
    IHasInventory inv;
    NonNullList<ItemStack> array;

    public ChachedInventory(IHasInventory inventory) {
        this.inv = inventory;
        this.array = NonNullList.func_191197_a((int)inventory.getSlotCount(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < this.array.size(); ++i) {
            this.array.set(i, (Object)this.inv.getStackInSlot(i).func_77946_l());
        }
    }

    public ChachedInventory(IHasInventory inventory, NBTTagCompound nbt) {
        this.inv = inventory;
        this.array = NonNullList.func_191197_a((int)inventory.getSlotCount(), (Object)ItemStack.field_190927_a);
        NBTTagList list = nbt.func_150295_c("items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            byte slot = data.func_74771_c("Slot");
            if (slot < 0 || slot >= inventory.getSlotCount()) continue;
            this.array.set((int)slot, (Object)new ItemStack(data));
        }
    }

    @Override
    public void applyChanges() {
        for (int i = 0; i < this.array.size(); ++i) {
            this.inv.setStackInSlot(i, (ItemStack)this.array.get(i));
        }
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.array.set(slot, (Object)stack);
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.array.get(slot);
    }

    @Override
    public int getSlotCount() {
        return this.inv.getSlotCount();
    }

    @Override
    public int getMaxStackSize(int slot) {
        return this.inv.getMaxStackSize(slot);
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return true;
    }

    public Map<Integer, ItemStack[]> getManualDifference() {
        LinkedHashMap<Integer, ItemStack[]> result = new LinkedHashMap<Integer, ItemStack[]>();
        for (int i = 0; i < this.inv.getSlotCount(); ++i) {
            ItemStack first = (ItemStack)this.array.get(i);
            if (ItemStack.func_77989_b((ItemStack)this.inv.getStackInSlot(i), (ItemStack)first) && (first.func_190926_b() || first.func_190916_E() >= first.func_77976_d())) continue;
            result.put(i, new ItemStack[]{this.inv.getStackInSlot(i).func_77946_l(), first.func_77946_l()});
        }
        return result;
    }

    public Map<Integer, ItemStack[]> getDifferences() {
        LinkedHashMap<Integer, ItemStack[]> result = new LinkedHashMap<Integer, ItemStack[]>();
        for (int i = 0; i < this.inv.getSlotCount(); ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.inv.getStackInSlot(i), (ItemStack)((ItemStack)this.array.get(i)))) continue;
            result.put(i, new ItemStack[]{this.inv.getStackInSlot(i).func_77946_l(), ((ItemStack)this.array.get(i)).func_77946_l()});
        }
        return result;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.array.size(); ++i) {
            ItemStack stack = (ItemStack)this.array.get(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound data = stack.func_77955_b(new NBTTagCompound());
            data.func_74774_a("Slot", (byte)i);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("items", (NBTBase)list);
        return nbt;
    }

    public ChachedInventory copy() {
        ChachedInventory inv = new ChachedInventory(this.inv);
        for (int i = 0; i < this.getSlotCount(); ++i) {
            inv.setStackInSlot(i, this.getStackInSlot(i).func_77946_l());
        }
        return inv;
    }
}

