/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.render.model;

import ic2.core.item.misc.ItemDisplayIcon;
import ic2.core.platform.textures.Ic2Models;
import ic2.core.platform.textures.helpers.TextureOverrideList;
import ic2.core.platform.textures.models.BaseModel;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FluidModel
extends BaseModel
implements TextureOverrideList.IModelUpdate {
    List<BakedQuad>[] fluidModels;
    int currentModel = 0;

    public FluidModel() {
        super(Ic2Models.getItemTransforms());
        this.setParticalTexture(this.getMap().func_174944_f());
    }

    @Override
    public void init() {
        this.fluidModels = this.createList(FluidRegistry.getMaxID() + 1);
        this.fluidModels[0].addAll(this.createTextures(FluidRegistry.WATER));
        for (Map.Entry entry : FluidRegistry.getRegisteredFluidIDs().entrySet()) {
            this.fluidModels[(Integer)entry.getValue()].addAll(this.createTextures((Fluid)entry.getKey()));
        }
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null && side == null) {
            return this.fluidModels[this.currentModel];
        }
        return this.getEmptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return new TextureOverrideList(this);
    }

    @Override
    public void onUpdate(ItemStack stack) {
        FluidStack fluid = ItemDisplayIcon.getFluidStack(stack);
        if (fluid == null) {
            this.currentModel = 0;
            return;
        }
        this.currentModel = (Integer)FluidRegistry.getRegisteredFluidIDs().get(fluid.getFluid());
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getCamera(), (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    public List<BakedQuad> createTextures(Fluid fluid) {
        return ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)this.getTexture(fluid), (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(this.getCamera().get((Object)ItemCameraTransforms.TransformType.FIXED)));
    }

    public TextureMap getMap() {
        return Minecraft.func_71410_x().func_147117_R();
    }

    public TextureAtlasSprite getTexture(Fluid fluid) {
        if (fluid == null) {
            fluid = FluidRegistry.WATER;
        }
        return this.getMap().func_110572_b(fluid.getStill().toString());
    }
}

